/*
 * Decompiled with CFR 0.152.
 */
package com.bluersw.source;

import com.bluersw.source.DataSource;
import com.bluersw.source.FileRead;
import com.bluersw.source.HttpRequest;
import com.bluersw.source.Protocol;

public class DataSourceFactory {
    public static DataSource createDataSource(Protocol protocol, String uri) {
        if (protocol == Protocol.HTTP_HTTPS) {
            return new HttpRequest(uri);
        }
        if (protocol == Protocol.FILE_PATH) {
            return new FileRead(uri);
        }
        throw new IllegalArgumentException(String.format("Did not implement this protocol. protocol: %s", new Object[]{protocol}));
    }
}

