/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.cryptomove;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import io.jenkins.plugins.cryptomove.Messages;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CryptoMoveBuilder
extends Builder
implements SimpleBuildStep {
    private final String name;
    private final String email;
    private final String token;

    @DataBoundConstructor
    public CryptoMoveBuilder(String name, String token, String email) {
        this.name = name;
        this.email = email;
        this.token = token;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        URL url = new URL("https://api.cryptomove.com/v1/user/secret/list_no_dup");
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        http.setRequestProperty("Authorization", this.token);
        http.setRequestProperty("Content-Type", "application/json");
        JsonObject listNoDupJson = Json.createObjectBuilder().add("email", this.email).build();
        String listNoDupBody = listNoDupJson.toString();
        DataOutputStream wr = new DataOutputStream(http.getOutputStream());
        wr.writeBytes(listNoDupBody);
        wr.flush();
        wr.close();
        http.connect();
        int status = http.getResponseCode();
        if (status >= 300) {
            InputStream inputStream = http.getInputStream();
            String body = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            listener.getLogger().println("there was an error with your request " + body);
            throw new RuntimeException("there was an error in the request");
        }
        InputStream inputStream = http.getInputStream();
        String body = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
        listener.getLogger().println("You have the keys " + body);
        ProcessBuilder pb = new ProcessBuilder("/bin/bash", "-c", this.name);
        Map<String, String> env = pb.environment();
        env.put("CRYPTOMOVE", "vault");
        Process p = pb.start();
        String stderr = IOUtils.toString((InputStream)p.getErrorStream(), (Charset)Charset.defaultCharset());
        String stdout = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset());
        listener.getLogger().println("Standard Error " + stderr);
        listener.getLogger().println("Standard Out " + stdout);
        listener.getLogger().println("You are running the command: " + this.name);
        listener.getLogger().println("You are using the token: " + this.token);
    }

    @Symbol(value={"cryptomove"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckName(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.CryptoMoveBuilder_DescriptorImpl_errors_missingName());
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)Messages.CryptoMoveBuilder_DescriptorImpl_warnings_tooShort());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckToken(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.CryptoMoveBuilder_DescriptorImpl_errors_missingToken());
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)Messages.CryptoMoveBuilder_DescriptorImpl_warnings_tooShort());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEmail(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.CryptoMoveBuilder_DescriptorImpl_errors_missingEmail());
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)Messages.CryptoMoveBuilder_DescriptorImpl_warnings_tooShort());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.CryptoMoveBuilder_DescriptorImpl_DisplayName();
        }
    }
}

