/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark.data;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.benchmark.Messages;
import io.jenkins.plugins.benchmark.data.BenchmarkResults;
import io.jenkins.plugins.benchmark.data.ReadResult;
import io.jenkins.plugins.benchmark.data.Reader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class CSVReader
extends Reader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public ReadResult read(String path) throws Reader.InputException {
        HashMap<String, Double> l = new HashMap<String, Double>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(this.getBufferedReader(path));
            String line = in.readLine();
            String name = null;
            if (line == null) {
                throw new Reader.InputException(Messages.fileIsNotPresent());
            }
            int linenr = 1;
            String e = null;
            boolean searchSep = true;
            char seperator = ';';
            if (this.isHeader(line)) {
                Character sep = this.findSeperatorInHeader(line);
                if (sep != null) {
                    seperator = sep.charValue();
                    searchSep = false;
                }
                line = in.readLine();
                ++linenr;
            }
            int dot = 95;
            while (line != null) {
                String[] s;
                if (searchSep) {
                    try {
                        seperator = this.findSeperator(line);
                        searchSep = false;
                    }
                    catch (BenchmarkResults.WrongFormatException e1) {
                        e = Messages.wrong_file_format(linenr, line);
                    }
                }
                if ((s = line.split("" + seperator)).length == 2 && s[0].toLowerCase().equals("name")) {
                    name = s[1];
                } else {
                    if (s.length == 2 && seperator == ';') {
                        if (dot == 95) {
                            if (s[1].contains(".")) {
                                dot = 46;
                            } else if (s[1].contains(",")) {
                                dot = 44;
                            }
                        }
                        if (dot == 44) {
                            s[1] = s[1].replace(',', '.');
                        }
                    }
                    if (s.length == 2 && s[0].length() > 0 && this.isDouble(s[1])) {
                        l.put(s[0], Double.parseDouble(s[1]));
                    } else if (e == null) {
                        e = Messages.wrong_file_format(linenr, line);
                    }
                }
                ++linenr;
                line = in.readLine();
                if (line != null) continue;
            }
            ReadResult readResult = new ReadResult(name, l, e);
            return readResult;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    private boolean isHeader(String in) {
        boolean dot = false;
        for (int i = in.length() - 1; i >= 0; --i) {
            if (in.charAt(i) == ';') {
                return false;
            }
            if (in.charAt(i) == '.') {
                dot = true;
                continue;
            }
            if (in.charAt(i) == ',' && dot) {
                return false;
            }
            if (Character.isDigit(in.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private Character findSeperatorInHeader(String in) {
        if (in.contains(";") && in.indexOf(59) == in.lastIndexOf(59) && !in.contains(",")) {
            return Character.valueOf(';');
        }
        if (in.contains(",") && in.indexOf(44) == in.lastIndexOf(44) && !in.contains(";")) {
            return Character.valueOf(',');
        }
        return null;
    }

    private char findSeperator(String in) throws BenchmarkResults.WrongFormatException {
        boolean dot = false;
        boolean comma = false;
        boolean simicolon = false;
        block5: for (int i = in.length() - 1; i >= 0; --i) {
            switch (in.charAt(i)) {
                case ';': {
                    if (dot && comma) {
                        throw new BenchmarkResults.WrongFormatException();
                    }
                    simicolon = true;
                    continue block5;
                }
                case '.': {
                    dot = true;
                    continue block5;
                }
                case ',': {
                    comma = true;
                    continue block5;
                }
                default: {
                    if (!Character.isDigit(in.charAt(i))) break block5;
                }
            }
        }
        return simicolon ? (char)';' : ',';
    }
}

