/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark.configuration;

import com.google.gson.Gson;
import io.jenkins.plugins.benchmark.configuration.BenchmarkConfigLoader;
import io.jenkins.plugins.benchmark.configuration.ConfigEntry;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BenchmarkConfiguration {
    private static ConcurrentHashMap<String, BenchmarkConfiguration> allConfigurations = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConfigEntry> config;
    private BenchmarkConfigLoader bl;
    private String path;
    private Object loadhelper = new Object();

    private BenchmarkConfiguration(String path) {
        this.path = path;
    }

    public static BenchmarkConfiguration getConfig(String path) {
        if (!path.toLowerCase().endsWith(".config")) {
            return null;
        }
        BenchmarkConfiguration bc = allConfigurations.compute(path, (k, v) -> v == null ? new BenchmarkConfiguration((String)k) : v);
        try {
            bc.load();
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not find configuration file: " + path);
            e.printStackTrace();
            return null;
        }
        return bc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws FileNotFoundException {
        Object object = this.loadhelper;
        synchronized (object) {
            if (this.bl == null) {
                this.config = new ConcurrentHashMap();
                this.bl = new BenchmarkConfigLoader(this.path, this.config);
            }
        }
    }

    public boolean add(String metric, ConfigEntry config) {
        ConfigEntry r = this.config.compute(metric, (m, a) -> {
            if (a == null) {
                return config;
            }
            if (a.getBuildNr() == -1) {
                return new ConfigEntry(a.getMinPercent(), a.getMaxPercent(), a.getMinValue(), a.getMaxValue(), a.getUnit(), config.getBuildNr());
            }
            return a;
        });
        this.bl.save();
        return r == config;
    }

    public ConfigEntry get(String metric) {
        return this.config.get(metric);
    }

    public boolean change(String metric, ConfigEntry config) {
        ConfigEntry r = this.config.computeIfPresent(metric, (x, y) -> config);
        if (r == config) {
            this.bl.save();
            return true;
        }
        return false;
    }

    public boolean delete(String metric) {
        ConfigEntry deleted = new ConfigEntry(null, null, null, null, null, -1000);
        ConfigEntry r = this.config.computeIfPresent(metric, (x, y) -> {
            if (y.getBuildNr() == -1) {
                this.config.remove(x);
                return deleted;
            }
            return y;
        });
        this.bl.save();
        return r == deleted;
    }

    public int getSize() {
        return this.config.size();
    }

    public String getConfigAsJson() {
        return new Gson().toJson(this.config);
    }

    public Set<Map.Entry<String, ConfigEntry>> getEntrys() {
        return this.config.entrySet();
    }

    public BenchmarkConfiguration copy() {
        BenchmarkConfiguration b = new BenchmarkConfiguration(null);
        b.config = new ConcurrentHashMap();
        this.config.forEach((x, y) -> b.config.put((String)x, (ConfigEntry)y));
        return b;
    }
}

