/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.benchmark.configuration.ConfigEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

class BenchmarkConfigLoader {
    private static String head = "metrikname;minPercent_since_last_build;maxPercent_since_last_build;min_value;max_value;unit;buildNr";
    private String path;
    private final Map<String, ConfigEntry> config;
    private final AtomicBoolean unwrittenChanges = new AtomicBoolean(false);
    private static ExecutorService pool = Executors.newFixedThreadPool(1);

    BenchmarkConfigLoader(String path, Map<String, ConfigEntry> config) throws FileNotFoundException {
        this.path = path;
        this.config = config;
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    void load() throws FileNotFoundException {
        BufferedReader in = null;
        Map<String, ConfigEntry> map = this.config;
        synchronized (map) {
            File f = new File(this.path);
            if (!f.exists()) {
                PrintWriter out = null;
                try {
                    out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                    out.println(head);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (out == null) {
                        throw new FileNotFoundException("Could not create config: " + f);
                    }
                    out.close();
                }
                return;
            }
            try {
                in = new BufferedReader(new FileReader(f));
                String line = in.readLine();
                while ((line = in.readLine()) != null) {
                    String[] colums = line.split(";");
                    if (colums.length != 7 || !this.isInteger(colums[6])) continue;
                    int buildNr = Integer.parseInt(colums[6]);
                    ConfigEntry c = new ConfigEntry(this.isDouble(colums[1]) ? Double.valueOf(Double.parseDouble(colums[1])) : null, this.isDouble(colums[2]) ? Double.valueOf(Double.parseDouble(colums[2])) : null, this.isDouble(colums[3]) ? Double.valueOf(Double.parseDouble(colums[3])) : null, this.isDouble(colums[4]) ? Double.valueOf(Double.parseDouble(colums[4])) : null, colums[5].equals("") ? null : colums[5], buildNr > -1 ? buildNr : -1);
                    this.config.put(colums[0], c);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private boolean isDouble(String b) {
        if (b == null || b.length() == 0) {
            return false;
        }
        boolean point = false;
        for (int i = 0; i < b.length(); ++i) {
            if (i == 0 && b.charAt(i) == '-') continue;
            if ((b.charAt(i) < '0' || b.charAt(i) > '9') && b.charAt(i) != '.') {
                return false;
            }
            if (b.charAt(i) != '.') continue;
            if (point) {
                return false;
            }
            point = true;
        }
        return true;
    }

    private boolean isInteger(String b) {
        if (b == null || b.length() == 0) {
            return false;
        }
        for (int i = 0; i < b.length(); ++i) {
            if (i == 0 && b.charAt(i) == '-' || b.charAt(i) >= '0' && b.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void save() {
        Map<String, ConfigEntry> map = this.config;
        synchronized (map) {
            if (!this.unwrittenChanges.get()) {
                this.unwrittenChanges.set(true);
                pool.execute(new SaveRunnable(this.path, this.config, this.unwrittenChanges));
            }
        }
    }

    private String nullasNothing(Double in) {
        if (in == null) {
            return "";
        }
        return in.toString();
    }

    private class SaveRunnable
    implements Runnable {
        private String path;
        private final Map<String, ConfigEntry> config;
        private final AtomicBoolean unwrittenChanges;

        public SaveRunnable(String path, Map<String, ConfigEntry> config, AtomicBoolean unwrittenChanges) {
            this.path = path;
            this.config = config;
            this.unwrittenChanges = unwrittenChanges;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE", "DM_DEFAULT_ENCODING", "JLM_JSR166_UTILCONCURRENT_MONITORENTER"})
        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            File f = new File(this.path + ".tmp");
            PrintWriter out = null;
            boolean b = false;
            Map<String, ConfigEntry> map = this.config;
            synchronized (map) {
                b = this.unwrittenChanges.get();
                if (b) {
                    try {
                        PrintWriter out2 = out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
                        out.println(head);
                        this.config.forEach((m, v) -> out2.println(String.format("%s;%s;%s;%s;%s;%s;%s", m, BenchmarkConfigLoader.this.nullasNothing(v.getMinPercent()), BenchmarkConfigLoader.this.nullasNothing(v.getMaxPercent()), BenchmarkConfigLoader.this.nullasNothing(v.getMinValue()), BenchmarkConfigLoader.this.nullasNothing(v.getMaxValue()), v.getUnit() == null ? "" : v.getUnit(), v.getBuildNr())));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                    this.unwrittenChanges.set(false);
                    try {
                        File oldF = new File(this.path);
                        if (oldF.exists()) {
                            oldF.delete();
                        }
                        f.renameTo(oldF);
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

