/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.benchmark;

import com.google.gson.Gson;
import hudson.model.Build;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.plugins.benchmark.BenchmarkBuilder;
import io.jenkins.plugins.benchmark.Messages;
import io.jenkins.plugins.benchmark.configuration.BenchmarkConfiguration;
import io.jenkins.plugins.benchmark.configuration.ConfigEntry;
import io.jenkins.plugins.benchmark.data.ReadResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.model.RunAction2;

public class BenchmarkAction
implements RunAction2 {
    private final ReadResult results;
    private transient Run<?, ?> run;
    private BenchmarkBuilder benchmarkBuilder;
    private final boolean succes;
    private final BenchmarkConfiguration benchmarkConfig;

    public BenchmarkAction(ReadResult m, BenchmarkBuilder benchmarkBuilder, boolean succes, BenchmarkConfiguration conf) {
        this.results = m;
        this.benchmarkBuilder = benchmarkBuilder;
        this.succes = succes;
        this.benchmarkConfig = conf;
    }

    public Map<String, Double> getResults() {
        return this.results != null ? this.results.getMessurements() : null;
    }

    public String getFirstResultsAsJson() {
        if (this.getResults() == null) {
            return "undefined";
        }
        ArrayList<Build> allBuilds = new ArrayList<Build>();
        Run o = this.run.getPreviousSuccessfulBuild();
        while (o != null && o instanceof Build) {
            allBuilds.add((Build)o);
            o = ((Build)o).getPreviousSuccessfulBuild();
        }
        if (!allBuilds.isEmpty()) {
            HashMap<String, Double> firstresults = new HashMap<String, Double>();
            List list = this.results.getMessurements().entrySet().parallelStream().map(x -> {
                ConfigEntry y = this.getConfig().get((String)x.getKey());
                return y != null ? new Pair((String)x.getKey(), y.getBuildNr()) : null;
            }).filter(x -> x != null).sorted((x, y) -> x.buildnr - y.buildnr).collect(Collectors.toList());
            int index = allBuilds.size() - 1;
            block1: do {
                int buildnr = Integer.parseInt(((Build)allBuilds.get(index)).getDisplayName().substring(1));
                BenchmarkAction a = this.getPreviousAction((Build)allBuilds.get(index));
                if (a == null || a.getResults() == null) continue;
                int i = 0;
                Pair p = null;
                while (i < list.size()) {
                    p = (Pair)list.get(i);
                    if (p.buildnr > buildnr) continue block1;
                    Double c = a.getResults().get(p.metric);
                    if (c != null) {
                        list.remove(p);
                        firstresults.put(p.metric, c);
                        continue;
                    }
                    ++i;
                }
            } while (--index >= 0 && !list.isEmpty());
            if (!firstresults.isEmpty()) {
                return new Gson().toJson(firstresults);
            }
        }
        return "undefined";
    }

    public String getLastStableResultAsJson() {
        return this.getLastResultsAsJson(true);
    }

    public String getLastResultsAsJson() {
        return this.getLastResultsAsJson(false);
    }

    public String getLastResultsAsJson(boolean stable) {
        if (this.getResults() == null) {
            return "undefined";
        }
        Run o = stable ? this.run.getPreviousSuccessfulBuild() : this.run.getPreviousBuild();
        while (o != null && o instanceof Build) {
            BenchmarkAction r = this.getPreviousAction((Build)o);
            if (r != null && r.getResults() != null) {
                return new Gson().toJson(r.getResults());
            }
            o = this.wasSuccesfull() && r != null ? null : ((Build)o).getPreviousBuild();
        }
        return "undefined";
    }

    public String getCurrentResultsAsJson() {
        if (this.getResults() != null) {
            return new Gson().toJson(this.getResults());
        }
        return "undefined";
    }

    public String getFilePath() {
        return this.benchmarkBuilder.getFilepath();
    }

    public String getIconFileName() {
        return "/plugin/benchmark-evaluator/images/256x256/result.png";
    }

    public String getName() {
        return this.results != null ? this.results.getName() : null;
    }

    public String getDisplayName() {
        return Messages.benchmark_result() + " " + (this.getName() == null ? "" + this.getBuildNumber() : this.getName());
    }

    public String getUrlName() {
        return "benchmark_" + this.getBuildNumber();
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public BenchmarkBuilder getBenchmarkBuilder() {
        return this.benchmarkBuilder;
    }

    private int getBuildNumber() {
        return this.run.getActions(this.getClass()).indexOf(this) + 1;
    }

    private BenchmarkAction getPreviousAction(Build<?, ?> b) {
        Optional<BenchmarkAction> l = b.getActions(this.getClass()).stream().filter(x -> x.getBenchmarkBuilder().equals((Object)this.benchmarkBuilder)).findFirst();
        return l.isPresent() ? l.get() : null;
    }

    public boolean wasSuccesfull() {
        return this.run.getResult() == Result.SUCCESS;
    }

    public BenchmarkConfiguration getConfig() {
        return this.benchmarkConfig;
    }

    public String getConfigAsJson() {
        return this.getConfig().getConfigAsJson();
    }

    public boolean wasCurrentActionSuccesfull() {
        return this.succes;
    }

    public String getUnits() {
        return "{" + this.benchmarkBuilder.getConfig(this.run).getEntrys().stream().filter(x -> ((ConfigEntry)x.getValue()).getUnit() != null).map(x -> String.format("'%s':'%s'", x.getKey(), ((ConfigEntry)x.getValue()).getUnit())).collect(Collectors.joining(",")) + "}";
    }

    private static class Pair {
        public final String metric;
        public final int buildnr;

        public Pair(String metric, int buildnr) {
            this.metric = metric;
            this.buildnr = buildnr;
        }
    }
}

