/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jenkins.plugins.sam.util;

import hudson.FilePath;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ZipHelper {
    private static final byte[] MAGIC = new byte[]{80, 75, 3, 4};

    public static boolean isZipStream(InputStream in) {
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        boolean isZip = true;
        try {
            in.mark(MAGIC.length);
            for (int i = 0; i < MAGIC.length; ++i) {
                if (MAGIC[i] == (byte)in.read()) continue;
                isZip = false;
                break;
            }
            in.reset();
        }
        catch (IOException e) {
            isZip = false;
        }
        return isZip;
    }

    public static void zipDirectoryContents(FilePath directory, FilePath zipFile) throws IOException, InterruptedException {
        ZipOutputStream zipStream = new ZipOutputStream(zipFile.write());
        zipStream.setMethod(8);
        zipStream.setLevel(6);
        try {
            ZipHelper.addDirectoryToZip(directory, zipStream, directory.getRemote());
        }
        catch (IOException | InterruptedException e) {
            zipStream.close();
            throw e;
        }
        zipStream.close();
    }

    private static void addDirectoryToZip(FilePath directory, ZipOutputStream zipStream, String rootPath) throws IOException, InterruptedException {
        for (FilePath file : directory.list()) {
            if (file.isDirectory()) {
                ZipHelper.addDirectoryToZip(file, zipStream, rootPath);
                continue;
            }
            ZipEntry entry = new ZipEntry(file.getRemote().substring(rootPath.length() + 1));
            entry.setTime(file.lastModified());
            entry.setSize(file.length());
            zipStream.putNextEntry(entry);
            IOUtils.copy((InputStream)new BufferedInputStream(file.read()), (OutputStream)zipStream);
            zipStream.closeEntry();
        }
    }
}

