/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jenkins.plugins.sam.util;

import java.util.Arrays;
import java.util.HashMap;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class IntrinsicsYamlConstructor
extends Constructor {
    public IntrinsicsYamlConstructor() {
        this.addIntrinsic("And");
        this.addIntrinsic("Base64");
        this.addIntrinsic("Cidr");
        this.addIntrinsic("Condition", false);
        this.addIntrinsic("Equals");
        this.addIntrinsic("FindInMap");
        this.addIntrinsic("GetAtt", true, true);
        this.addIntrinsic("GetAZs");
        this.addIntrinsic("If");
        this.addIntrinsic("ImportValue");
        this.addIntrinsic("Join");
        this.addIntrinsic("Not");
        this.addIntrinsic("Or");
        this.addIntrinsic("Ref", false);
        this.addIntrinsic("Select");
        this.addIntrinsic("Split");
        this.addIntrinsic("Sub");
    }

    private void addIntrinsic(String tag) {
        this.addIntrinsic(tag, true);
    }

    private void addIntrinsic(String tag, boolean attachFnPrefix) {
        this.addIntrinsic(tag, attachFnPrefix, false);
    }

    private void addIntrinsic(String tag, boolean attachFnPrefix, boolean forceSequenceValue) {
        this.yamlConstructors.put(new Tag("!" + tag), new ConstructFunction(attachFnPrefix, forceSequenceValue));
    }

    private class ConstructFunction
    extends AbstractConstruct {
        private final boolean attachFnPrefix;
        private final boolean forceSequenceValue;

        public ConstructFunction(boolean attachFnPrefix, boolean forceSequenceValue) {
            this.attachFnPrefix = attachFnPrefix;
            this.forceSequenceValue = forceSequenceValue;
        }

        public Object construct(Node node) {
            String key = node.getTag().getValue().substring(1);
            String prefix = this.attachFnPrefix ? "Fn::" : "";
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(prefix + key, this.constructIntrinsicValueObject(node));
            return result;
        }

        protected Object constructIntrinsicValueObject(Node node) {
            if (node instanceof ScalarNode) {
                Object val = IntrinsicsYamlConstructor.this.constructScalar((ScalarNode)node);
                if (this.forceSequenceValue) {
                    val = Arrays.asList(((String)val).split("\\."));
                }
                return val;
            }
            if (node instanceof SequenceNode) {
                return IntrinsicsYamlConstructor.this.constructSequence((SequenceNode)node);
            }
            if (node instanceof MappingNode) {
                return IntrinsicsYamlConstructor.this.constructMapping((MappingNode)node);
            }
            throw new YAMLException("Intrisic function arguments cannot be parsed.");
        }
    }
}

