/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.jenkins.plugins.sam.export;

import com.amazonaws.jenkins.plugins.sam.export.ArtifactResources;
import com.amazonaws.jenkins.plugins.sam.export.ArtifactUploader;
import com.amazonaws.jenkins.plugins.sam.export.BucketProperties;
import com.amazonaws.jenkins.plugins.sam.export.TemplateParser;
import com.amazonaws.jenkins.plugins.sam.model.SamPluginException;
import com.amazonaws.jenkins.plugins.sam.util.ZipHelper;
import com.amazonaws.services.s3.AmazonS3URI;
import hudson.FilePath;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class ArtifactExporter {
    protected final Map<String, Object> template;
    protected final FilePath templateDir;
    protected final ArtifactUploader uploader;

    private ArtifactExporter(FilePath templatePath, ArtifactUploader uploader) throws IOException, InterruptedException {
        this.template = new TemplateParser().parse(templatePath.read());
        this.templateDir = templatePath.getParent();
        this.uploader = uploader;
    }

    public static ArtifactExporter build(FilePath templatePath, ArtifactUploader uploader) throws IOException, InterruptedException {
        return new ArtifactExporter(templatePath, uploader);
    }

    public Map<String, Object> export() {
        Map resources = (Map)this.template.get("Resources");
        if (resources == null) {
            return this.template;
        }
        for (Map.Entry entry : resources.entrySet()) {
            Map resource = (Map)entry.getValue();
            String resourceType = (String)resource.get("Type");
            Map resourceProperties = (Map)resource.get("Properties");
            try {
                ArtifactResources resourceDefinition = ArtifactResources.fromType(resourceType);
                this.buildResourceExporter(resourceDefinition).export(resourceProperties);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return this.template;
    }

    private ResourceExporter buildResourceExporter(ArtifactResources resource) {
        if (resource == ArtifactResources.CLOUD_FORMATION_STACK) {
            return new CloudFormationStackResourceExporter(resource);
        }
        if (resource.hasBucketProperties()) {
            return new ResourceWithBucketExporter(resource);
        }
        return new ResourceExporter(resource);
    }

    private boolean isS3URI(String str) {
        try {
            new AmazonS3URI(str);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private class CloudFormationStackResourceExporter
    extends ResourceExporter {
        private CloudFormationStackResourceExporter(ArtifactResources resource) {
            super(resource);
        }

        @Override
        protected String performUpload(FilePath artifactsFilePath) {
            try {
                ArtifactExporter exporter = new ArtifactExporter(artifactsFilePath, ArtifactExporter.this.uploader);
                Map<String, Object> nestedTemplate = exporter.export();
                FilePath templateFile = artifactsFilePath.getParent().createTempFile(".sam", null);
                Yaml yaml = new Yaml();
                OutputStreamWriter writer = new OutputStreamWriter(templateFile.write(), StandardCharsets.UTF_8);
                yaml.dump(nestedTemplate, (Writer)writer);
                writer.close();
                String s3URI = ArtifactExporter.this.uploader.upload(templateFile, "template");
                templateFile.delete();
                return s3URI;
            }
            catch (IOException | InterruptedException e) {
                throw new SamPluginException("Nested template cannot be exported", e);
            }
        }

        @Override
        protected void updateArtifactsPath(Map<String, Object> resourceProperties, String artifactsS3Url) {
            resourceProperties.put(this.resourceDefinition.getArtifactsPathProperty(), ArtifactExporter.this.uploader.buildS3PathStyleURI(artifactsS3Url));
        }
    }

    private class ResourceWithBucketExporter
    extends ResourceExporter {
        private ResourceWithBucketExporter(ArtifactResources resource) {
            super(resource);
        }

        @Override
        protected void updateArtifactsPath(Map<String, Object> resourceProperties, String artifactsS3Url) {
            AmazonS3URI s3URI = new AmazonS3URI(artifactsS3Url);
            BucketProperties bucketProperties = this.resourceDefinition.getBucketProperties();
            String versionProperty = bucketProperties.getVersionProperty();
            String versionId = s3URI.getVersionId();
            HashMap<String, String> uriMap = new HashMap<String, String>();
            uriMap.put(bucketProperties.getBucketNameProperty(), s3URI.getBucket());
            uriMap.put(bucketProperties.getObjectKeyProperty(), s3URI.getKey());
            if (versionProperty != null && versionId != null) {
                uriMap.put(versionProperty, versionId);
            }
            resourceProperties.put(this.resourceDefinition.getArtifactsPathProperty(), uriMap);
        }
    }

    private class ResourceExporter {
        protected final ArtifactResources resourceDefinition;

        private ResourceExporter(ArtifactResources resourceDefinition) {
            this.resourceDefinition = resourceDefinition;
        }

        private void export(Map<String, Object> resourceProperties) {
            Object artifactsPath = resourceProperties.get(this.resourceDefinition.getArtifactsPathProperty());
            if (artifactsPath == null && !this.resourceDefinition.isWorkspacePackageAllowed()) {
                return;
            }
            if (artifactsPath instanceof Map) {
                return;
            }
            String artifactsS3Url = this.uploadArtifacts((String)artifactsPath);
            this.updateArtifactsPath(resourceProperties, artifactsS3Url);
        }

        private String uploadArtifacts(String artifactsPath) {
            if (artifactsPath == null) {
                return ArtifactExporter.this.uploader.upload(ArtifactExporter.this.templateDir);
            }
            if (ArtifactExporter.this.isS3URI(artifactsPath)) {
                return artifactsPath;
            }
            FilePath artifactsFilePath = ArtifactExporter.this.templateDir.child(artifactsPath);
            try {
                if (!artifactsFilePath.isDirectory() && !ZipHelper.isZipStream(artifactsFilePath.read()) && this.resourceDefinition.isForceZip()) {
                    FilePath tmpDir = ArtifactExporter.this.templateDir.createTempDir(".sam", null);
                    artifactsFilePath.getParent().copyRecursiveTo(artifactsFilePath.getName(), tmpDir);
                    String s3URI = this.performUpload(tmpDir);
                    tmpDir.deleteRecursive();
                    return s3URI;
                }
            }
            catch (IOException | InterruptedException e) {
                throw new SamPluginException("Artifact file cannot be uploaded to S3", e);
            }
            return this.performUpload(artifactsFilePath);
        }

        protected String performUpload(FilePath artifactsFilePath) {
            return ArtifactExporter.this.uploader.upload(artifactsFilePath);
        }

        protected void updateArtifactsPath(Map<String, Object> resourceProperties, String artifactsS3Url) {
            resourceProperties.put(this.resourceDefinition.getArtifactsPathProperty(), artifactsS3Url);
        }
    }
}

