/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemPropertyUtils {
    private static final Logger LOG = Logger.getLogger(SystemPropertyUtils.class.getName());

    public static long parsePositiveLongFromSystemProperty(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null && !propertyValue.trim().isEmpty()) {
            try {
                long longValue = Long.parseLong(propertyValue);
                if (longValue >= 0L) {
                    return longValue;
                }
                LOG.log(Level.WARNING, String.format("Value of system property '%s' is negative ('%s') defaulting to %s", propertyName, longValue, defaultValue));
            }
            catch (NumberFormatException e) {
                LOG.log(Level.WARNING, String.format("Failed to parse long value from system property '%s' (was: '%s'), defaulting to %s", propertyName, propertyValue, defaultValue), e);
            }
        }
        return defaultValue;
    }
}

