/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm.trait;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryProvider;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketTagClient;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMHeadDiscoveryHandler;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRevision;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSourceContext;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketTagSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketTagSourceBranch;
import com.atlassian.bitbucket.jenkins.internal.scm.Messages;
import hudson.Extension;
import hudson.plugins.git.extensions.GitSCMExtension;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.inject.Inject;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.kohsuke.stapler.DataBoundConstructor;

public class BitbucketTagDiscoveryTrait
extends SCMSourceTrait {
    private static final Logger log = Logger.getLogger(BitbucketTagDiscoveryTrait.class.getName());

    @DataBoundConstructor
    public BitbucketTagDiscoveryTrait() {
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        GitSCMBuilder gitSCMBuilder;
        SCMRevision revision;
        if (builder instanceof GitSCMBuilder && (revision = (gitSCMBuilder = (GitSCMBuilder)builder).revision()) instanceof BitbucketSCMRevision && revision.getHead() instanceof BitbucketTagSCMHead) {
            BitbucketSCMRevision tagRevision = (BitbucketSCMRevision)revision;
            BitbucketTagSCMHead tagHead = (BitbucketTagSCMHead)tagRevision.getHead();
            gitSCMBuilder.withExtension((GitSCMExtension)new BitbucketTagSourceBranch(tagHead));
        }
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        if (context instanceof BitbucketSCMSourceContext) {
            final BitbucketSCMSourceContext bitbucketContext = (BitbucketSCMSourceContext)context;
            DescriptorImpl descriptor = (DescriptorImpl)this.getDescriptor();
            Optional<BitbucketClientFactory> clientFactory = descriptor.getClientFactory(bitbucketContext);
            if (!clientFactory.isPresent()) {
                log.log(Level.WARNING, "Server configuration missing, cannot resolve client for Tag discovery");
                return;
            }
            BitbucketSCMRepository repository = bitbucketContext.getRepository();
            final BitbucketTagClient bitbucketTagClient = clientFactory.get().getProjectClient(repository.getProjectKey()).getRepositoryClient(repository.getRepositorySlug()).getBitbucketTagClient(bitbucketContext.getTaskListener());
            bitbucketContext.withDiscoveryHandler(new BitbucketSCMHeadDiscoveryHandler(){

                @Override
                public Stream<? extends SCMHead> discoverHeads() {
                    if (bitbucketContext.getEventHeads().isEmpty()) {
                        return bitbucketTagClient.getRemoteTags().map(BitbucketTagSCMHead::new);
                    }
                    return bitbucketContext.getEventHeads().stream().filter(BitbucketTagSCMHead.class::isInstance);
                }

                @Override
                public SCMRevision toRevision(SCMHead head) {
                    if (head instanceof BitbucketTagSCMHead) {
                        return new BitbucketSCMRevision((BitbucketTagSCMHead)head, ((BitbucketTagSCMHead)head).getLatestCommit());
                    }
                    IllegalStateException e = new IllegalStateException("The specified head needs to be an instance of BitbucketTagSCMHead");
                    e.setStackTrace(new StackTraceElement[0]);
                    throw e;
                }
            });
        }
    }

    @Discovery
    @Extension
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        @Inject
        private BitbucketClientFactoryProvider bitbucketClientFactoryProvider;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        @Inject
        private JenkinsToBitbucketCredentials jenkinsToBitbucketCredentials;

        public Class<? extends SCMBuilder> getBuilderClass() {
            return GitSCMBuilder.class;
        }

        public Optional<BitbucketClientFactory> getClientFactory(BitbucketSCMSourceContext bitbucketContext) {
            return this.bitbucketPluginConfiguration.getServerById(bitbucketContext.getRepository().getServerId()).map(BitbucketServerConfiguration::getBaseUrl).map(baseUrl -> this.bitbucketClientFactoryProvider.getClient((String)baseUrl, this.jenkinsToBitbucketCredentials.toBitbucketCredentials(bitbucketContext.getCredentials())));
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return BitbucketSCMSourceContext.class;
        }

        public String getDisplayName() {
            return Messages.bitbucket_scm_trait_discovery_tag_display();
        }

        public Class<? extends SCMSource> getSourceClass() {
            return BitbucketSCMSource.class;
        }
    }
}

