/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm.trait;

import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketBranchDiscoveryTrait;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketGitBrowserSCMSourceTrait;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketIgnoreOnPushNotificationTrait;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketRefSpecsSCMSourceTrait;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketRemoteNameSCMSourceTrait;
import com.atlassian.bitbucket.jenkins.internal.scm.trait.BitbucketTagDiscoveryTrait;
import javax.annotation.CheckForNull;
import jenkins.plugins.git.traits.BranchDiscoveryTrait;
import jenkins.plugins.git.traits.DiscoverOtherRefsTrait;
import jenkins.plugins.git.traits.GitBrowserSCMSourceTrait;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.plugins.git.traits.RefSpecsSCMSourceTrait;
import jenkins.plugins.git.traits.RemoteNameSCMSourceTrait;
import jenkins.plugins.git.traits.TagDiscoveryTrait;
import jenkins.scm.api.trait.SCMSourceTrait;

public class BitbucketLegacyTraitConverter {
    private BitbucketLegacyTraitConverter() {
    }

    @CheckForNull
    public static SCMSourceTrait maybeConvert(SCMSourceTrait trait) {
        if (trait instanceof DiscoverOtherRefsTrait) {
            return null;
        }
        if (trait instanceof BranchDiscoveryTrait) {
            return new BitbucketBranchDiscoveryTrait();
        }
        if (trait instanceof TagDiscoveryTrait) {
            return new BitbucketTagDiscoveryTrait();
        }
        if (trait instanceof GitBrowserSCMSourceTrait) {
            return new BitbucketGitBrowserSCMSourceTrait(((GitBrowserSCMSourceTrait)trait).getBrowser());
        }
        if (trait instanceof IgnoreOnPushNotificationTrait) {
            return new BitbucketIgnoreOnPushNotificationTrait();
        }
        if (trait instanceof RefSpecsSCMSourceTrait) {
            return new BitbucketRefSpecsSCMSourceTrait(((RefSpecsSCMSourceTrait)trait).getTemplates());
        }
        if (trait instanceof RemoteNameSCMSourceTrait) {
            return new BitbucketRemoteNameSCMSourceTrait(((RemoteNameSCMSourceTrait)trait).getRemoteName());
        }
        return trait;
    }
}

