/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequest;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPullRequestState;
import java.io.Serializable;
import javax.annotation.CheckForNull;

public class MinimalPullRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String fromLatestCommit;
    private final String fromRefDisplayId;
    private final String fromRefId;
    private final int fromRepositoryId;
    private final long pullRequestId;
    private final BitbucketPullRequestState state;
    private final String title;
    private final String toLatestCommit;
    private final String toRefDisplayId;
    private final String toRefId;
    private final int toRepositoryId;

    public MinimalPullRequest(BitbucketPullRequest pullRequest) {
        this.description = pullRequest.getDescription();
        this.fromLatestCommit = pullRequest.getFromRef().getLatestCommit();
        this.fromRefId = pullRequest.getFromRef().getId();
        this.fromRefDisplayId = pullRequest.getFromRef().getDisplayId();
        this.fromRepositoryId = pullRequest.getFromRef().getRepository().getId();
        this.pullRequestId = pullRequest.getId();
        this.state = pullRequest.getState();
        this.title = pullRequest.getTitle();
        this.toLatestCommit = pullRequest.getToRef().getLatestCommit();
        this.toRefId = pullRequest.getToRef().getId();
        this.toRefDisplayId = pullRequest.getToRef().getDisplayId();
        this.toRepositoryId = pullRequest.getToRef().getRepository().getId();
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public String getFromLatestCommit() {
        return this.fromLatestCommit;
    }

    public String getFromRefDisplayId() {
        return this.fromRefDisplayId;
    }

    public String getFromRefId() {
        return this.fromRefId;
    }

    public int getFromRepositoryId() {
        return this.fromRepositoryId;
    }

    public Long getPullRequestId() {
        return this.pullRequestId;
    }

    public BitbucketPullRequestState getState() {
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public String getToLatestCommit() {
        return this.toLatestCommit;
    }

    public String getToRefDisplayId() {
        return this.toRefDisplayId;
    }

    public String getToRefId() {
        return this.toRefId;
    }

    public int getToRepositoryId() {
        return this.toRepositoryId;
    }

    public boolean isForkedPullRequest() {
        return this.fromRepositoryId != this.toRepositoryId;
    }
}

