/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model.deployment;

public enum DeploymentState {
    PENDING("%s is waiting to deploy to %s."),
    IN_PROGRESS("%s is deploying to %s."),
    CANCELLED("%s deployment to %s cancelled."),
    FAILED("%s failed to deploy to %s."),
    ROLLED_BACK("%s deployment to %s was rolled back."),
    SUCCESSFUL("%s successfully deployed to %s"),
    UNKNOWN("State of %s deploying to %s is unknown.");

    private final String formatString;

    private DeploymentState(String formatString) {
        this.formatString = formatString;
    }

    public String getDescriptiveText(String jobName, String environmentName) {
        return String.format(this.formatString, jobName, environmentName);
    }
}

