/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model.deployment;

import com.atlassian.bitbucket.jenkins.internal.deployments.Messages;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;

public enum BitbucketDeploymentEnvironmentType {
    DEVELOPMENT(Messages.BitbucketDeploymentEnvironmentType_DEVELOPMENT(), 3),
    PRODUCTION(Messages.BitbucketDeploymentEnvironmentType_PRODUCTION(), 0),
    STAGING(Messages.BitbucketDeploymentEnvironmentType_STAGING(), 1),
    TESTING(Messages.BitbucketDeploymentEnvironmentType_TESTING(), 2);

    private static final Map<String, BitbucketDeploymentEnvironmentType> types;
    private final String displayName;
    private final int weight;

    private BitbucketDeploymentEnvironmentType(String displayName, int weight) {
        this.displayName = displayName;
        this.weight = weight;
    }

    public static Optional<BitbucketDeploymentEnvironmentType> fromName(@CheckForNull String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return Optional.empty();
        }
        return Optional.ofNullable(types.get(name.toUpperCase(Locale.US)));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getWeight() {
        return this.weight;
    }

    static {
        types = Stream.of(BitbucketDeploymentEnvironmentType.values()).collect(Collectors.toMap(t -> t.name().toUpperCase(Locale.US), Function.identity()));
    }
}

