/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.auth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.OAuth1aRequestFilter;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.Terminator;
import hudson.util.PluginServletFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.ServletException;

@Extension
public class OAuthFilterRegistrar {
    private static final Logger log = Logger.getLogger(OAuthFilterRegistrar.class.getName());
    @Inject
    private OAuth1aRequestFilter requestHandler;

    @Initializer(after=InitMilestone.PLUGINS_PREPARED)
    public void onStart() {
        try {
            this.addFilter();
        }
        catch (ServletException e) {
            log.log(Level.SEVERE, "Failed to add filter in filter chain", e);
        }
    }

    @Terminator
    public void onStop() {
        try {
            this.removeFilter();
        }
        catch (ServletException e) {
            log.log(Level.WARNING, "Failed to remove filter from filter chain", e);
        }
    }

    void addFilter() throws ServletException {
        PluginServletFilter.addFilter((Filter)this.requestHandler);
    }

    void removeFilter() throws ServletException {
        PluginServletFilter.removeFilter((Filter)this.requestHandler);
    }
}

