/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCommitClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.client.paging.BitbucketPageStreamUtil;
import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketCommit;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.CheckForNull;
import okhttp3.HttpUrl;

public class BitbucketCommitClientImpl
implements BitbucketCommitClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;
    private final String repositorySlug;

    public BitbucketCommitClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repositorySlug) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
    }

    @Override
    @CheckForNull
    public BitbucketCommit getCommit(String identifier) {
        HttpUrl url = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug).addPathSegment("commits").addQueryParameter("until", identifier).addQueryParameter("start", "0").addQueryParameter("limit", "1").build();
        BitbucketPage<BitbucketCommit> firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketCommit>>(){}, new RequestConfiguration[0]).getBody();
        return BitbucketPageStreamUtil.toStream(firstPage, new OnlyPageFetcherImpl()).map(BitbucketPage::getValues).flatMap(Collection::stream).findFirst().orElse(null);
    }

    static class OnlyPageFetcherImpl
    implements NextPageFetcher<BitbucketCommit> {
        OnlyPageFetcherImpl() {
        }

        @Override
        public BitbucketPage<BitbucketCommit> next(BitbucketPage<BitbucketCommit> previous) {
            if (previous.isLastPage()) {
                throw new IllegalArgumentException("Last page does not have next page");
            }
            BitbucketPage<BitbucketCommit> lastPage = new BitbucketPage<BitbucketCommit>();
            lastPage.setValues(Collections.emptyList());
            lastPage.setLastPage(true);
            return lastPage;
        }
    }
}

