/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.AbstractPersistentStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.StoreException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenUtils;
import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PersistentServiceProviderTokenStore
extends AbstractPersistentStore<ServiceProviderToken>
implements ServiceProviderTokenStore {
    private static final Logger log = Logger.getLogger(PersistentServiceProviderTokenStore.class.getName());
    private static final String TOKEN_STORE_ENTRY_NAME = "oauth-token";
    private static final String TOKEN_STORE_KEY_NAME = "token-value";
    private static final String TOKEN_STORE_VALUE_NAME = "token-details";

    @Inject
    public PersistentServiceProviderTokenStore(ServiceProviderConsumerStore consumerStore) {
        super("oauth-tokens.xml", new ServiceProviderTokenConverter(consumerStore));
    }

    @VisibleForTesting
    PersistentServiceProviderTokenStore(ServiceProviderConsumerStore ServiceProviderConsumerStore2, Map<String, ServiceProviderToken> tokenMap) {
        this(ServiceProviderConsumerStore2);
        this.entityMap = tokenMap;
    }

    @Override
    public Optional<ServiceProviderToken> get(String token) {
        Objects.requireNonNull(token, "token");
        this.load();
        return Optional.ofNullable((ServiceProviderToken)this.entityMap.get(token));
    }

    @Override
    public Iterable<ServiceProviderToken> getAccessTokensForUser(String username) {
        Objects.requireNonNull(username, "username");
        this.load();
        return this.entityMap.values().stream().filter(token -> Objects.equals(username, token.getUser())).collect(Collectors.toList());
    }

    @Override
    public ServiceProviderToken put(ServiceProviderToken token) {
        Objects.requireNonNull(token, "token");
        this.load();
        this.entityMap.put(token.getToken(), token);
        this.save();
        return token;
    }

    @Override
    public void remove(String token) {
        Objects.requireNonNull(token, "token");
        this.load();
        if (this.entityMap.remove(token) != null) {
            this.save();
        }
    }

    @Override
    public void removeExpiredTokens() {
        this.load();
        boolean needToSave = false;
        for (ServiceProviderToken token : this.entityMap.values()) {
            if (!ServiceProviderTokenUtils.isTokenExpired(token) || this.entityMap.remove(token.getToken()) == null) continue;
            needToSave = true;
        }
        if (needToSave) {
            this.save();
        }
    }

    @Override
    public void removeExpiredSessions() {
        this.load();
        boolean needToSave = false;
        for (ServiceProviderToken token : this.entityMap.values()) {
            if (!ServiceProviderTokenUtils.isTokenSessionExpired(token) || this.entityMap.remove(token.getToken()) == null) continue;
            needToSave = true;
        }
        if (needToSave) {
            this.save();
        }
    }

    @Override
    public void removeByConsumer(String consumerKey) {
        Objects.requireNonNull(consumerKey, "consumerKey");
        this.load();
        boolean needToSave = false;
        for (ServiceProviderToken token : this.entityMap.values()) {
            Consumer consumer = token.getConsumer();
            if (consumer == null || !Objects.equals(consumerKey, consumer.getKey()) || this.entityMap.remove(token.getToken()) == null) continue;
            needToSave = true;
        }
        if (needToSave) {
            this.save();
        }
    }

    @Override
    protected Class<ServiceProviderToken> getEntityClass() {
        return ServiceProviderToken.class;
    }

    @Override
    protected String getStoreValueName() {
        return TOKEN_STORE_VALUE_NAME;
    }

    @Override
    protected String getStoreKeyName() {
        return TOKEN_STORE_KEY_NAME;
    }

    @Override
    protected String getStoreEntryName() {
        return TOKEN_STORE_ENTRY_NAME;
    }

    private static final class ServiceProviderTokenConverter
    implements Converter {
        private static final String ACCESS_TOKEN = "access-token";
        private static final String TOKEN_VALUE = "token-value";
        private static final String TOKEN_SECRET = "token-secret";
        private static final String CONSUMER_KEY = "consumer-key";
        private static final String PROPERTIES = "properties";
        private static final String AUTHORIZATION = "authorization";
        private static final String USER = "user";
        private static final String VERIFIER = "verifier";
        private static final String TOKEN_CREATION_TIME = "creation-time";
        private static final String TOKEN_TIME_TO_LIVE = "time-to-live";
        private static final String CALLBACK = "callback";
        private static final String SESSION = "session";
        private static final String SESSION_HANDLE = "handle";
        private static final String SESSION_CREATION_TIME = "creation-time";
        private static final String SESSION_LAST_RENEWAL_TIME = "last-renewal-time";
        private static final String SESSION_TIME_TO_LIVE = "time-to-live";
        private final ServiceProviderConsumerStore consumerStore;

        private ServiceProviderTokenConverter(ServiceProviderConsumerStore consumerStore) {
            this.consumerStore = consumerStore;
        }

        public boolean canConvert(Class type) {
            return ServiceProviderToken.class == type;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            Objects.requireNonNull(source, "source");
            if (!(source instanceof ServiceProviderToken)) {
                log.severe(() -> String.format("Cannot marshal source of type '%s'", source.getClass()));
                throw new StoreException("Cannot marshal token: incorrect source type");
            }
            ServiceProviderToken token = (ServiceProviderToken)source;
            ServiceProviderTokenConverter.addNode(writer, ACCESS_TOKEN, token.isAccessToken());
            String tokenValue = token.getToken();
            ServiceProviderTokenConverter.addNode(writer, "token-value", PersistentServiceProviderTokenStore.encrypt(tokenValue));
            ServiceProviderTokenConverter.addNode(writer, TOKEN_SECRET, PersistentServiceProviderTokenStore.encrypt(token.getTokenSecret()));
            Optional.ofNullable(token.getConsumer()).map(Consumer::getKey).ifPresent(consumerKey -> ServiceProviderTokenConverter.addNode(writer, CONSUMER_KEY, consumerKey));
            ServiceProviderTokenConverter.addNode(writer, AUTHORIZATION, (Object)token.getAuthorization());
            ServiceProviderTokenConverter.addNode(writer, USER, token.getUser());
            ServiceProviderTokenConverter.addNode(writer, VERIFIER, PersistentServiceProviderTokenStore.encrypt(token.getVerifier()));
            ServiceProviderTokenConverter.addNode(writer, CALLBACK, token.getCallback());
            ServiceProviderTokenConverter.addNode(writer, "creation-time", token.getCreationTime());
            ServiceProviderTokenConverter.addNode(writer, "time-to-live", token.getTimeToLive());
            ServiceProviderTokenConverter.addProperties(writer, token.getProperties());
            ServiceProviderTokenConverter.addSession(writer, token.getSession());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Boolean accessToken = null;
            String tokenValue = null;
            String tokenSecret = null;
            String consumerKey = null;
            ServiceProviderToken.Authorization authorization = null;
            String user = null;
            String verifier = null;
            Long creationTime = null;
            Long timeToLive = null;
            URI callback = null;
            Map<String, String> properties = null;
            ServiceProviderToken.Session session = null;
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String name = reader.getNodeName();
                String value = reader.getValue();
                switch (name) {
                    case "access-token": {
                        accessToken = Boolean.valueOf(value);
                        break;
                    }
                    case "token-value": {
                        tokenValue = PersistentServiceProviderTokenStore.decrypt(value);
                        break;
                    }
                    case "token-secret": {
                        tokenSecret = PersistentServiceProviderTokenStore.decrypt(value);
                        break;
                    }
                    case "consumer-key": {
                        consumerKey = value;
                        break;
                    }
                    case "callback": {
                        callback = Optional.ofNullable(value).map(URI::create).orElse(null);
                        break;
                    }
                    case "authorization": {
                        authorization = ServiceProviderToken.Authorization.valueOf(value);
                        break;
                    }
                    case "user": {
                        user = value;
                        break;
                    }
                    case "verifier": {
                        verifier = PersistentServiceProviderTokenStore.decrypt(value);
                        break;
                    }
                    case "creation-time": {
                        creationTime = Long.valueOf(value);
                        break;
                    }
                    case "time-to-live": {
                        timeToLive = Long.valueOf(value);
                        break;
                    }
                    case "session": {
                        session = ServiceProviderTokenConverter.unmarshalSession(reader);
                        break;
                    }
                    case "properties": {
                        properties = ServiceProviderTokenConverter.unmarshalProperties(reader);
                        break;
                    }
                    default: {
                        log.fine(() -> String.format("Unknown token entry node '%s' with value '%s' is ignored.", name, value));
                    }
                }
                reader.moveUp();
            }
            try {
                Optional<Consumer> consumer = this.consumerStore.get(consumerKey);
                if (!consumer.isPresent()) {
                    log.warning("Consumer not found: " + consumerKey);
                    throw new StoreException("Consumer not found");
                }
                ServiceProviderToken.ServiceProviderTokenBuilder tokenBuilder = (ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)(accessToken != false ? ServiceProviderToken.newAccessToken(tokenValue) : ServiceProviderToken.newRequestToken(tokenValue)).tokenSecret(tokenSecret)).callback(callback).session(session).properties(properties)).verifier(verifier).creationTime(creationTime).timeToLive(timeToLive).consumer(consumer.get());
                if (ServiceProviderToken.Authorization.AUTHORIZED == authorization && user != null) {
                    tokenBuilder.authorizedBy(user);
                }
                return tokenBuilder.build();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to unmarshal tokens", e);
                throw new ConversionException("Failed to unmarshal tokens", (Throwable)e);
            }
        }

        private static void addProperties(HierarchicalStreamWriter writer, @Nullable Map<String, String> properties) {
            if (properties != null) {
                writer.startNode(PROPERTIES);
                properties.forEach((key, value) -> ServiceProviderTokenConverter.addNode(writer, key, value));
                writer.endNode();
            }
        }

        private static void addSession(HierarchicalStreamWriter writer, @Nullable ServiceProviderToken.Session session) {
            if (session != null) {
                writer.startNode(SESSION);
                ServiceProviderTokenConverter.addNode(writer, SESSION_HANDLE, PersistentServiceProviderTokenStore.encrypt(session.getHandle()));
                ServiceProviderTokenConverter.addNode(writer, "creation-time", session.getCreationTime());
                ServiceProviderTokenConverter.addNode(writer, SESSION_LAST_RENEWAL_TIME, session.getLastRenewalTime());
                ServiceProviderTokenConverter.addNode(writer, "time-to-live", session.getTimeToLive());
                writer.endNode();
            }
        }

        private static void addNode(HierarchicalStreamWriter writer, String name, Object value) {
            writer.startNode(name);
            writer.setValue(Objects.toString(value));
            writer.endNode();
        }

        private static Map<String, String> unmarshalProperties(HierarchicalStreamReader reader) {
            HashMap<String, String> properties = new HashMap<String, String>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                properties.put(reader.getNodeName(), reader.getValue());
                reader.moveUp();
            }
            return properties;
        }

        @Nullable
        private static ServiceProviderToken.Session unmarshalSession(HierarchicalStreamReader reader) {
            String handle = null;
            Long creationTime = null;
            Long lastRenewalTime = null;
            Long timeToLive = null;
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String name = reader.getNodeName();
                String value = reader.getValue();
                switch (name) {
                    case "handle": {
                        handle = PersistentServiceProviderTokenStore.decrypt(value);
                        break;
                    }
                    case "creation-time": {
                        creationTime = Long.valueOf(value);
                        break;
                    }
                    case "last-renewal-time": {
                        lastRenewalTime = Long.valueOf(value);
                        break;
                    }
                    case "time-to-live": {
                        timeToLive = Long.valueOf(value);
                        break;
                    }
                    default: {
                        log.fine(() -> String.format("Unknown token session entry node '%s' with value '%s' is ignored.", name, value));
                    }
                }
                reader.moveUp();
            }
            if (handle == null) {
                return null;
            }
            ServiceProviderToken.Session.Builder session = ServiceProviderToken.Session.newSession(handle);
            if (creationTime != null) {
                session.creationTime(creationTime);
            }
            if (lastRenewalTime != null) {
                session.lastRenewalTime(lastRenewalTime);
            }
            if (timeToLive != null) {
                session.timeToLive(timeToLive);
            }
            return session.build();
        }
    }
}

