/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import net.oauth.OAuth;
import net.oauth.server.HttpRequestMessage;
import org.apache.commons.lang3.StringUtils;

public final class OAuthRequestUtils {
    public static final String EXCLUSION_PATH = "/bitbucket/oauth/";
    private static final Set<String> OAUTH_DATA_REQUEST_PARAMS = Stream.of("oauth_consumer_key", "oauth_token", "oauth_signature_method", "oauth_signature", "oauth_timestamp", "oauth_nonce").collect(Collectors.toSet());

    private OAuthRequestUtils() {
    }

    public static boolean isOAuthAccessAttempt(HttpServletRequest request) {
        return OAuthRequestUtils.is3LOAuthAccessAttempt(request) || OAuthRequestUtils.is2LOAuthAccessAttempt(request);
    }

    public static boolean isOauthTokenRequest(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        return !StringUtils.isEmpty((CharSequence)pathInfo) && pathInfo.startsWith(EXCLUSION_PATH);
    }

    private static boolean is2LOAuthAccessAttempt(HttpServletRequest request) {
        Map<String, String> params = OAuthRequestUtils.extractParameters(request);
        return params.keySet().containsAll(OAUTH_DATA_REQUEST_PARAMS) && StringUtils.isEmpty((CharSequence)params.get("oauth_token")) && !OAuthRequestUtils.isRequestTokenRequest(request);
    }

    private static boolean is3LOAuthAccessAttempt(HttpServletRequest request) {
        Map<String, String> params = OAuthRequestUtils.extractParameters(request);
        return params.keySet().containsAll(OAUTH_DATA_REQUEST_PARAMS) && params.containsKey("oauth_token") && !StringUtils.isEmpty((CharSequence)params.get("oauth_token")) && !OAuthRequestUtils.isAccessTokenRequest(request);
    }

    private static boolean isRequestTokenRequest(HttpServletRequest request) {
        return request.getRequestURI().endsWith("request-token");
    }

    private static boolean isAccessTokenRequest(HttpServletRequest request) {
        return request.getRequestURI().endsWith("access-token");
    }

    private static Map<String, String> extractParameters(HttpServletRequest request) {
        return HttpRequestMessage.getParameters((HttpServletRequest)request).stream().collect(Collectors.toMap(OAuth.Parameter::getKey, OAuth.Parameter::getValue, (a, b) -> a));
    }
}

