/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.StoreException;
import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.extended.NamedMapConverter;
import hudson.BulkChange;
import hudson.XmlFile;
import hudson.model.Saveable;
import hudson.util.CopyOnWriteMap;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.util.io.OnMaster;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPersistentStore<T>
implements Saveable,
OnMaster {
    private static final Logger log = Logger.getLogger(AbstractPersistentStore.class.getName());
    private static final int PRIORITY = 100;
    @VisibleForTesting
    protected final transient XStream2 xStream;
    protected volatile Map<String, T> entityMap;
    private final String configFileName;

    protected AbstractPersistentStore(String configFileName, Converter entityConverter) {
        this.configFileName = Objects.requireNonNull(configFileName, "configFileName");
        this.xStream = new XStream2();
        this.xStream.registerConverter((Converter)new NamedMapConverter(this.xStream.getMapper(), this.getStoreEntryName(), this.getStoreKeyName(), String.class, this.getStoreValueName(), this.getEntityClass()), 100);
        this.xStream.registerConverter(entityConverter);
    }

    public synchronized void load() {
        if (this.entityMap != null) {
            return;
        }
        XmlFile configFile = this.getConfigFile();
        if (configFile.exists()) {
            try {
                configFile.unmarshal((Object)this);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Failed to load items from disk", e);
                throw new StoreException("Failed to load from disk", e);
            }
        }
        this.entityMap = new CopyOnWriteMap.Hash(this.entityMap != null ? this.entityMap : Collections.emptyMap());
    }

    public synchronized void save() {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        try {
            this.getConfigFile().write((Object)this);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failed to persist items to disk", e);
            throw new StoreException("Failed to persist to disk", e);
        }
    }

    @VisibleForTesting
    protected XmlFile getConfigFile() {
        return new XmlFile((XStream)this.xStream, new File(Jenkins.get().getRootDir(), this.configFileName));
    }

    @Nullable
    protected static String encrypt(@Nullable String unencryptedValue) {
        if (StringUtils.isBlank((CharSequence)unencryptedValue)) {
            return unencryptedValue;
        }
        return Secret.fromString((String)unencryptedValue).getEncryptedValue();
    }

    @Nullable
    protected static String decrypt(@Nullable String encryptedValue) {
        if (StringUtils.isBlank((CharSequence)encryptedValue)) {
            return encryptedValue;
        }
        return Secret.toString((Secret)Secret.decrypt((String)encryptedValue));
    }

    protected abstract Class<T> getEntityClass();

    protected abstract String getStoreValueName();

    protected abstract String getStoreKeyName();

    protected abstract String getStoreEntryName();
}

