/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger.register;

import java.util.Objects;

public class WebhookRegisterRequest {
    private static final int MAX_WEBHOOK_NAME_LENGTH = 255;
    private final String jenkinsUrl;
    private final boolean isMirror;
    private final String name;
    private final String projectKey;
    private final String repoSlug;

    private WebhookRegisterRequest(String projectKey, String repoSlug, String name, String jenkinsUrl, boolean isMirror) {
        this.projectKey = Objects.requireNonNull(projectKey);
        this.repoSlug = Objects.requireNonNull(repoSlug);
        this.name = Objects.requireNonNull(name);
        this.jenkinsUrl = Objects.requireNonNull(jenkinsUrl);
        this.isMirror = isMirror;
    }

    public String getName() {
        return this.name;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public String getRepoSlug() {
        return this.repoSlug;
    }

    public boolean isMirror() {
        return this.isMirror;
    }

    public static class Builder {
        private final String projectKey;
        private final String repoSlug;
        private boolean isMirror;
        private String jenkinsUrl;
        private String serverId;

        private Builder(String projectKey, String repoSlug) {
            this.projectKey = projectKey;
            this.repoSlug = repoSlug;
        }

        public static Builder aRequest(String project, String repoSlug) {
            return new Builder(project, repoSlug);
        }

        public WebhookRegisterRequest build() {
            return new WebhookRegisterRequest(this.projectKey, this.repoSlug, this.serverId, this.jenkinsUrl, this.isMirror);
        }

        public Builder isMirror(boolean isMirror) {
            this.isMirror = isMirror;
            return this;
        }

        public Builder withJenkinsBaseUrl(String jenkinsUrl) {
            this.jenkinsUrl = jenkinsUrl;
            return this;
        }

        public Builder withName(String name) {
            if (name.length() > 255) {
                throw new IllegalArgumentException(String.format("Webhook name should be less than %d characters", 255));
            }
            this.serverId = name;
            return this;
        }
    }
}

