/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Project;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.Stapler;

public class BitbucketExternalLink
implements Action,
IconSpec {
    private final Project project;
    private final String displayName;
    private final String url;
    private final String iconName;

    private BitbucketExternalLink(Project project, String displayName, String url, String iconClassName) {
        this.project = project;
        this.displayName = displayName;
        this.url = url;
        this.iconName = iconClassName;
    }

    public static BitbucketExternalLink createDashboardLink(String url, Project project) {
        String displayName = "Go to Bitbucket";
        String iconName = "icon-bitbucket-logo";
        return new BitbucketExternalLink(project, displayName, url, iconName);
    }

    public String getIconClassName() {
        return this.iconName;
    }

    @CheckForNull
    public String getIconFileName() {
        if (!this.project.hasPermission(Item.CONFIGURE)) {
            return null;
        }
        JellyContext ctx = new JellyContext();
        ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
        return IconSet.icons.getIconByClassSpec((Object)(this.iconName + " icon-md")).getQualifiedUrl(ctx);
    }

    @CheckForNull
    public String getDisplayName() {
        return this.displayName;
    }

    @CheckForNull
    public String getUrlName() {
        return this.url;
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-bitbucket-logo icon-md", "atlassian-bitbucket-server-integration/images/24x24/bitbucket.png", "width: 24px; height: 24px;", IconType.PLUGIN));
    }
}

