/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BitbucketWebhookRequest {
    private final Map<String, String> configuration;
    private final String name;
    private final Set<String> events;
    private final String url;
    private final boolean isActive;

    protected BitbucketWebhookRequest(String name, Set<String> events, String url, boolean isActive) {
        this.name = name;
        this.events = events;
        this.url = url;
        this.isActive = isActive;
        this.configuration = Collections.singletonMap("createdBy", "jenkins");
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getEvents() {
        return this.events;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public static final class Builder {
        private final Set<String> events;
        private String name;
        private String url;
        private boolean isActive = true;

        private Builder(Set<String> events) {
            this.events = events;
        }

        public static Builder aRequestFor(String event, String ... events) {
            LinkedHashSet<String> eventSet = new LinkedHashSet<String>();
            eventSet.add(event);
            eventSet.addAll(Arrays.asList(events));
            return Builder.aRequestFor(eventSet);
        }

        static Builder aRequestFor(Set<String> eventSet) {
            return new Builder(eventSet);
        }

        public BitbucketWebhookRequest build() {
            Objects.requireNonNull(this.events, "Specify the webhook events");
            Objects.requireNonNull(this.url, "Specify the Call back URL");
            Objects.requireNonNull(this.name, "Specify the name of the webhook.");
            return new BitbucketWebhookRequest(this.name, this.events, this.url, this.isActive);
        }

        public Builder withIsActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder withCallbackTo(String url) {
            this.url = url;
            return this;
        }
    }
}

