/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.RepositoryState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BitbucketRepository {
    private final int id;
    private final String name;
    private final BitbucketProject project;
    private final String slug;
    private final RepositoryState state;
    private List<BitbucketNamedLink> cloneUrls = new ArrayList<BitbucketNamedLink>();
    private String selfLink;

    @JsonCreator
    public BitbucketRepository(@JsonProperty(value="id") int id, @JsonProperty(value="name") String name, @CheckForNull @JsonProperty(value="links") Map<String, List<BitbucketNamedLink>> links, @JsonProperty(value="project") BitbucketProject project, @JsonProperty(value="slug") String slug, @JsonProperty(value="state") RepositoryState state) {
        this.id = id;
        this.name = name;
        this.project = project;
        this.slug = slug;
        this.state = state;
        if (links != null) {
            this.setLinks(links);
        }
    }

    public BitbucketRepository(int repositoryId, String name, BitbucketProject project, String slug, RepositoryState state, List<BitbucketNamedLink> cloneUrls, String selfLink) {
        this.id = repositoryId;
        this.name = name;
        this.project = project;
        this.slug = slug;
        this.state = state;
        this.cloneUrls = cloneUrls;
        this.selfLink = selfLink;
    }

    public int getId() {
        return this.id;
    }

    public List<BitbucketNamedLink> getCloneUrls() {
        return this.cloneUrls;
    }

    public String getName() {
        return this.name;
    }

    public BitbucketProject getProject() {
        return this.project;
    }

    public String getSelfLink() {
        return StringUtils.stripToEmpty((String)this.selfLink);
    }

    public String getSlug() {
        return this.slug;
    }

    public RepositoryState getState() {
        return this.state;
    }

    private void setLinks(Map<String, List<BitbucketNamedLink>> rawLinks) {
        List<BitbucketNamedLink> clones = rawLinks.get("clone");
        this.cloneUrls = clones != null ? Collections.unmodifiableList(clones) : Collections.emptyList();
        List<BitbucketNamedLink> link = rawLinks.get("self");
        if (link != null && !link.isEmpty()) {
            this.selfLink = link.get(0).getHref();
        }
    }
}

