/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.consumer.OAuthGlobalConfiguration;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token.DisplayAccessToken;
import com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token.Messages;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsAuthWrapper;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class OAuthTokenConfiguration
implements Action,
Describable<OAuthGlobalConfiguration> {
    public static final String REVOKE_BUTTON_NAME = "Revoke";
    @Inject
    private JenkinsAuthWrapper jenkinsAuthWrapper;
    @Inject
    private Clock clock;
    @Inject
    private ServiceProviderTokenStore tokenStore;

    OAuthTokenConfiguration(JenkinsAuthWrapper jenkinsAuthWrapper, Clock clock, ServiceProviderTokenStore tokenStore) {
        this.jenkinsAuthWrapper = jenkinsAuthWrapper;
        this.clock = clock;
        this.tokenStore = tokenStore;
    }

    public OAuthTokenConfiguration() {
    }

    @CheckForNull
    public String getIconFileName() {
        return "secure.gif";
    }

    @CheckForNull
    public String getDisplayName() {
        return Messages.bitbucket_oauth_token_revoke_name();
    }

    @CheckForNull
    public String getUrlName() {
        return "tokens";
    }

    public List<DisplayAccessToken> getTokens() {
        ArrayList<DisplayAccessToken> tokenList = new ArrayList<DisplayAccessToken>();
        this.tokenStore.getAccessTokensForUser(this.jenkinsAuthWrapper.getAuthentication().getName()).forEach(token -> tokenList.add(new DisplayAccessToken((ServiceProviderToken)token, this.clock)));
        return tokenList;
    }

    @RequirePOST
    public HttpResponse doRevoke(StaplerRequest request) {
        request.getParameterMap().entrySet().stream().filter(e -> ((String[])e.getValue()).length == 1 && ((String[])e.getValue())[0].equals(REVOKE_BUTTON_NAME)).map(Map.Entry::getKey).forEach(t -> this.tokenStore.remove((String)t));
        return HttpResponses.redirectToDot();
    }

    public Descriptor<OAuthGlobalConfiguration> getDescriptor() {
        return Jenkins.get().getDescriptorOrDie(this.getClass());
    }
}

