/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.token;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.time.Clock;
import java.util.Date;

public class DisplayAccessToken
extends AbstractDescribableImpl<DisplayAccessToken> {
    private Clock clock;
    private ServiceProviderToken token;

    public DisplayAccessToken(ServiceProviderToken token, Clock clock) {
        this.token = token;
        this.clock = clock;
    }

    public Date getCreationDate() {
        return new Date(this.token.getCreationTime());
    }

    public String getConsumerName() {
        return this.token.getConsumer().getName();
    }

    public String getToken() {
        return this.token.getToken();
    }

    public String getTokenStatus() {
        if (this.token.hasExpired(this.clock)) {
            return "EXPIRED";
        }
        if (this.token.hasBeenDenied()) {
            return "DENIED";
        }
        if (this.token.hasBeenAuthorized()) {
            return "AUTHORIZED";
        }
        return "NOT YET AUTHORIZED";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DisplayAccessToken> {
        public String getDisplayName() {
            return "Token";
        }
    }
}

