/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.jenkins.oauth.servlet;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.Randomizer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.InvalidTokenException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.util.OAuthProblemUtils;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsAuthWrapper;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Action;
import hudson.model.Descriptor;
import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;

public class AuthorizeConfirmationConfig
extends AbstractDescribableImpl<AuthorizeConfirmationConfig>
implements Action {
    public static final String ACCESS_REQUEST = "read and write";
    public static final String ALLOW_KEY = "authorize";
    public static final String DENY_KEY = "cancel";
    public static final String OAUTH_TOKEN_PARAM = "oauth_token";
    public static final String OAUTH_CALLBACK_PARAM = "oauth_callback";
    private static final String DENIED_STATUS = "denied";
    private static final Logger LOGGER = Logger.getLogger(AuthorizeConfirmationConfig.class.getName());
    private static final int VERIFIER_LENGTH = 6;
    private AuthorizeConfirmationConfigDescriptor descriptor;
    private String callback;
    private ServiceProviderToken serviceProviderToken;

    private AuthorizeConfirmationConfig(AuthorizeConfirmationConfigDescriptor descriptor, String rawToken, String callback) throws OAuthProblemException {
        this.descriptor = descriptor;
        this.serviceProviderToken = this.getTokenForAuthorization(rawToken);
        this.callback = callback;
    }

    public HttpResponse doPerformSubmit(StaplerRequest request) throws IOException, ServletException {
        ServiceProviderToken newToken;
        ServiceProviderToken token;
        JSONObject data = request.getSubmittedForm();
        Map params = request.getParameterMap();
        Authentication userPrincipal = this.descriptor.jenkinsAuthWrapper.getAuthentication();
        if (Jenkins.ANONYMOUS.getPrincipal().equals(userPrincipal.getName())) {
            return HttpResponses.error((int)401, (String)"User not logged in.");
        }
        try {
            token = this.getTokenForAuthorization(data.getString(OAUTH_TOKEN_PARAM));
        }
        catch (OAuthProblemException e) {
            OAuthProblemUtils.logOAuthProblem(OAuthServlet.getMessage((HttpServletRequest)request, null), e, LOGGER);
            return HttpResponses.error((Throwable)e);
        }
        if (params.containsKey(DENY_KEY)) {
            newToken = token.deny(userPrincipal.getName());
        } else if (params.containsKey(ALLOW_KEY)) {
            String verifier = this.getDescriptor().randomizer.randomAlphanumericString(6);
            newToken = token.authorize(userPrincipal.getName(), verifier);
        } else {
            return HttpResponses.error((int)400, (String)"Bad Request");
        }
        this.getDescriptor().tokenStore.put(newToken);
        String callBackUrl = OAuth.addParameters((String)((String)data.get(OAUTH_CALLBACK_PARAM)), (String[])new String[]{OAUTH_TOKEN_PARAM, newToken.getToken(), "oauth_verifier", newToken.getAuthorization() == ServiceProviderToken.Authorization.AUTHORIZED ? newToken.getVerifier() : DENIED_STATUS});
        return HttpResponses.redirectTo((String)callBackUrl);
    }

    public String getAccessRequest() {
        return ACCESS_REQUEST;
    }

    public String getAuthenticatedUsername() {
        return this.descriptor.jenkinsAuthWrapper.getAuthentication().getName();
    }

    public String getCallback() {
        return this.callback;
    }

    public String getConsumerName() {
        return this.serviceProviderToken.getConsumer().getName();
    }

    public AuthorizeConfirmationConfigDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDisplayName() {
        return "Authorize";
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    public String getIconUrl() {
        return Jenkins.get().getRootUrl() + "/plugin/atlassian-bitbucket-server-integration/images/bitbucket-to-jenkins.png";
    }

    public String getInstanceName() {
        return "Jenkins";
    }

    public String getToken() {
        return this.serviceProviderToken.getToken();
    }

    public String getUrlName() {
        return ALLOW_KEY;
    }

    private ServiceProviderToken getTokenForAuthorization(String rawToken) throws OAuthProblemException {
        ServiceProviderToken token;
        try {
            token = this.getDescriptor().tokenStore.get(rawToken).orElseThrow(() -> new OAuthProblemException("token_rejected"));
        }
        catch (InvalidTokenException e) {
            throw new OAuthProblemException("token_rejected");
        }
        if (token.isAccessToken()) {
            throw new OAuthProblemException("token_rejected");
        }
        if (token.getAuthorization() == ServiceProviderToken.Authorization.AUTHORIZED || token.getAuthorization() == ServiceProviderToken.Authorization.DENIED) {
            throw new OAuthProblemException("token_used");
        }
        if (token.hasExpired(this.getDescriptor().clock)) {
            throw new OAuthProblemException("token_expired");
        }
        return token;
    }

    @Extension
    public static class AuthorizeConfirmationConfigDescriptor
    extends Descriptor<AuthorizeConfirmationConfig> {
        @Inject
        private JenkinsAuthWrapper jenkinsAuthWrapper;
        @Inject
        private Clock clock;
        @Inject
        private Randomizer randomizer;
        @Inject
        private ServiceProviderTokenStore tokenStore;

        AuthorizeConfirmationConfigDescriptor(JenkinsAuthWrapper jenkinsAuthWrapper, ServiceProviderTokenStore tokenStore, Randomizer randomizer, Clock clock) {
            this.jenkinsAuthWrapper = jenkinsAuthWrapper;
            this.tokenStore = tokenStore;
            this.randomizer = randomizer;
            this.clock = clock;
        }

        public AuthorizeConfirmationConfigDescriptor() {
        }

        public AuthorizeConfirmationConfig createInstance(@Nullable StaplerRequest req) throws Descriptor.FormException {
            try {
                OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)req, null);
                requestMessage.requireParameters(new String[]{AuthorizeConfirmationConfig.OAUTH_TOKEN_PARAM});
                return new AuthorizeConfirmationConfig(this, requestMessage.getToken(), requestMessage.getParameter(AuthorizeConfirmationConfig.OAUTH_CALLBACK_PARAM));
            }
            catch (OAuthProblemException e) {
                throw new Descriptor.FormException((Throwable)e, e.getProblem());
            }
            catch (IOException e) {
                throw new Descriptor.FormException((Throwable)e, e.getMessage());
            }
        }

        public AuthorizeConfirmationConfig newInstance(@Nullable StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return this.createInstance(req);
        }

        public boolean isAuthenticated() {
            return this.jenkinsAuthWrapper.getAuthentication().isAuthenticated();
        }
    }
}

