/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClient;
import com.atlassian.bitbucket.jenkins.internal.client.paging.BitbucketPageStreamUtil;
import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhook;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhookRequest;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Stream;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import org.apache.commons.lang3.StringUtils;

public class BitbucketWebhookClientImpl
implements BitbucketWebhookClient {
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final HttpUrl url;

    BitbucketWebhookClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repoSlug) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        this.url = bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(Objects.requireNonNull(StringUtils.stripToNull((String)projectKey), "projectKey")).addPathSegment("repos").addPathSegment(Objects.requireNonNull(StringUtils.stripToNull((String)repoSlug), "repoSlug")).addPathSegment("webhooks").build();
    }

    @Override
    public void deleteWebhook(int webhookId) {
        HttpUrl deleteUrl = this.url.newBuilder().addPathSegment(String.valueOf(webhookId)).build();
        this.bitbucketRequestExecutor.makeDeleteRequest(deleteUrl);
    }

    @Override
    public BitbucketWebhook updateWebhook(int id, BitbucketWebhookRequest request) {
        HttpUrl updateUrl = this.url.newBuilder().addPathSegment(String.valueOf(id)).build();
        return this.bitbucketRequestExecutor.makePutRequest(updateUrl, request, BitbucketWebhook.class).getBody();
    }

    @Override
    public Stream<BitbucketWebhook> getWebhooks(String ... eventIdFilter) {
        HttpUrl.Builder urlBuilder = this.url.newBuilder();
        Arrays.stream(eventIdFilter).forEach(eventId -> urlBuilder.addQueryParameter("event", eventId));
        HttpUrl url = urlBuilder.build();
        BitbucketPage<BitbucketWebhook> firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketWebhook>>(){}).getBody();
        return BitbucketPageStreamUtil.toStream(firstPage, new NextPageFetcherImpl(url, this.bitbucketRequestExecutor)).map(BitbucketPage::getValues).flatMap(Collection::stream);
    }

    @Override
    public BitbucketWebhook registerWebhook(BitbucketWebhookRequest request) {
        return this.bitbucketRequestExecutor.makePostRequest(this.url, request, Headers.of(Collections.emptyMap()), BitbucketWebhook.class).getBody();
    }

    static class NextPageFetcherImpl
    implements NextPageFetcher<BitbucketWebhook> {
        private final HttpUrl url;
        private final BitbucketRequestExecutor bitbucketRequestExecutor;

        NextPageFetcherImpl(HttpUrl url, BitbucketRequestExecutor bitbucketRequestExecutor) {
            this.url = url;
            this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        }

        @Override
        public BitbucketPage<BitbucketWebhook> next(BitbucketPage<BitbucketWebhook> previous) {
            if (previous.isLastPage()) {
                throw new IllegalArgumentException("Last page does not have next page");
            }
            return this.bitbucketRequestExecutor.makeGetRequest(this.nextPageUrl(previous), new TypeReference<BitbucketPage<BitbucketWebhook>>(){}).getBody();
        }

        private HttpUrl nextPageUrl(BitbucketPage<BitbucketWebhook> previous) {
            return this.url.newBuilder().addQueryParameter("start", String.valueOf(previous.getNextPageStart())).build();
        }
    }
}

