/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketProject;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketRepository;
import java.util.Collection;

public final class BitbucketSearchHelper {
    public static Collection<BitbucketProject> findProjects(String projectName, BitbucketClientFactory clientFactory) throws BitbucketClientException {
        return clientFactory.getSearchClient(projectName).findProjects().getValues();
    }

    public static Collection<BitbucketRepository> findRepositories(String repositoryName, String projectName, BitbucketClientFactory client) throws BitbucketClientException {
        return client.getSearchClient(projectName).findRepositories(repositoryName).getValues();
    }

    public static BitbucketProject getProjectByNameOrKey(String projectNameOrKey, BitbucketClientFactory clientFactory) throws BitbucketClientException {
        return BitbucketSearchHelper.findProjects(projectNameOrKey, clientFactory).stream().filter(p -> projectNameOrKey.equalsIgnoreCase(p.getName())).findAny().orElseGet(() -> clientFactory.getProjectClient(projectNameOrKey).getProject());
    }

    public static BitbucketRepository getRepositoryByNameOrSlug(String projectNameOrKey, String repositoryNameOrSlug, BitbucketClientFactory clientFactory) throws BitbucketClientException {
        return BitbucketSearchHelper.findRepositories(repositoryNameOrSlug, projectNameOrKey, clientFactory).stream().filter(r -> repositoryNameOrSlug.equalsIgnoreCase(r.getName())).findAny().orElseGet(() -> clientFactory.getProjectClient(BitbucketSearchHelper.getProjectByNameOrKey(projectNameOrKey, clientFactory).getKey()).getRepositoryClient(repositoryNameOrSlug).getRepository());
    }
}

