/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import java.util.Objects;

public final class ServiceProviderTokenUtils {
    private ServiceProviderTokenUtils() {
    }

    public static boolean isTokenSessionExpired(ServiceProviderToken token) {
        Objects.requireNonNull(token, "token");
        ServiceProviderToken.Session session = token.getSession();
        return session != null && System.currentTimeMillis() > session.getLastRenewalTime() + session.getTimeToLive();
    }

    public static boolean isTokenExpired(ServiceProviderToken token) {
        Objects.requireNonNull(token, "token");
        return System.currentTimeMillis() > token.getCreationTime() + token.getTimeToLive();
    }
}

