/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactrepo.helper;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import io.jenkins.plugins.artifactrepo.Messages;
import io.jenkins.plugins.artifactrepo.model.ArtifactRepoParamProxy;
import io.jenkins.plugins.artifactrepo.model.HttpResponse;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpHelper {
    private static final Logger log = Logger.getLogger(HttpHelper.class.getName());
    private static final int SOCKET_TIMEOUT = 60;
    private static final int CONN_TIMEOUT = 60;
    private static final String AGENT = "Jenkins Plugin - Artifact Repository Parameter";

    /*
     * Exception decompiling
     */
    public static HttpResponse get(@Nonnull String url, @Nonnull HttpClientBuilder builder, @Nonnull HttpClientContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static HttpResponse get(@Nonnull String url, @Nonnull HttpClientBuilder builder) {
        return HttpHelper.get(url, builder, HttpClientContext.create());
    }

    public static HttpClientBuilder getBuilder(String repoCredId, ArtifactRepoParamProxy proxy, boolean ignoreSSL) {
        return Optional.of(HttpClients.custom()).map(HttpHelper::addDefaultConfig).map(builder -> HttpHelper.addBasicAuth(builder, repoCredId, proxy)).map(builder -> HttpHelper.addProxy(builder, proxy)).map(builder -> HttpHelper.addSslHandling(builder, ignoreSSL)).orElse(HttpClients.custom());
    }

    public static Optional<StandardUsernamePasswordCredentials> getCredentials(String credId) {
        if (StringUtils.isBlank((CharSequence)credId)) {
            log.info(Messages.log_missingCreds());
            return Optional.empty();
        }
        return CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), null, Collections.emptyList()).stream().filter(cred -> StringUtils.equals((CharSequence)cred.getId(), (CharSequence)credId)).findFirst();
    }

    public static HttpHost getHttpHostFromUrl(@Nonnull String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        return new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
    }

    private static HttpClientBuilder addDefaultConfig(HttpClientBuilder builder) {
        RequestConfig.Builder configBuilder = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT).setSocketTimeout(60000).setConnectionRequestTimeout(60000).setRedirectsEnabled(true).setMaxRedirects(10);
        return builder.setUserAgent(AGENT).setDefaultRequestConfig(configBuilder.build());
    }

    private static HttpClientBuilder addBasicAuth(HttpClientBuilder builder, String repoCredId, ArtifactRepoParamProxy proxy) {
        BasicCredentialsProvider httpProvider = new BasicCredentialsProvider();
        Optional<StandardUsernamePasswordCredentials> repoCred = HttpHelper.getCredentials(repoCredId);
        if (repoCred.isPresent()) {
            httpProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(repoCred.get().getUsername(), repoCred.get().getPassword().getPlainText()));
        } else {
            log.info(Messages.log_invalidCreds(repoCredId));
        }
        if (proxy == null || !proxy.isProxyActive()) {
            return builder.setDefaultCredentialsProvider((org.apache.http.client.CredentialsProvider)httpProvider);
        }
        Optional<StandardUsernamePasswordCredentials> proxyCredId = HttpHelper.getCredentials(proxy.getProxyCredentialsId());
        if (proxyCredId.isPresent()) {
            httpProvider.setCredentials(new AuthScope(proxy.getProxyHost(), Integer.parseInt(proxy.getProxyPort())), (Credentials)new UsernamePasswordCredentials(proxyCredId.get().getUsername(), proxyCredId.get().getPassword().getPlainText()));
        } else {
            log.info(Messages.log_invalidCreds(proxyCredId));
        }
        return builder.setDefaultCredentialsProvider((org.apache.http.client.CredentialsProvider)httpProvider);
    }

    private static HttpClientBuilder addProxy(HttpClientBuilder builder, ArtifactRepoParamProxy proxy) {
        ProxyConfiguration jenkinsProxy = Jenkins.get().proxy;
        HttpHost proxyHost = null;
        if (proxy != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proxy.getProxyHost(), proxy.getProxyPort()})) {
            proxyHost = new HttpHost(proxy.getProxyHost(), Integer.parseInt(proxy.getProxyPort()), proxy.getProxyProtocol());
        } else if (jenkinsProxy != null && StringUtils.isNotBlank((CharSequence)jenkinsProxy.name)) {
            proxyHost = new HttpHost(jenkinsProxy.name, jenkinsProxy.port);
        } else {
            log.info(Messages.log_disabledProxy());
        }
        return builder.setProxy(proxyHost);
    }

    private static HttpClientBuilder addSslHandling(HttpClientBuilder builder, boolean ignoreSSL) {
        if (!ignoreSSL) {
            return builder;
        }
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509Certificates, s) -> true).build();
            builder.setSSLContext(sslContext);
            NoopHostnameVerifier verifier = NoopHostnameVerifier.INSTANCE;
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)verifier));
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            log.log(Level.SEVERE, Messages.log_errorCertsProcessing(), e);
        }
        return builder;
    }

    private HttpHelper() {
    }
}

