/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.artifactrepo;

import hudson.Extension;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterValue;
import io.jenkins.plugins.artifactrepo.ArtifactRepoParamDescriptor;
import io.jenkins.plugins.artifactrepo.connectors.Connector;
import io.jenkins.plugins.artifactrepo.helper.AlphanumComparator;
import io.jenkins.plugins.artifactrepo.model.ArtifactRepoParamProxy;
import io.jenkins.plugins.artifactrepo.model.FormatType;
import io.jenkins.plugins.artifactrepo.model.RepoType;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ArtifactRepoParamDefinition
extends ParameterDefinition {
    private static final Logger log = Logger.getLogger(ArtifactRepoParamDefinition.class.getName());
    private final String uid = StringUtils.substringAfterLast((String)UUID.randomUUID().toString(), (String)"-");
    private final String serverType;
    private final String serverUrl;
    private final ArtifactRepoParamProxy proxy;
    private final String credentialsId;
    private final boolean ignoreCertificate;
    private final String paramType;
    private final String artifactName;
    private final String repoName;
    private final String versionRegex;
    private final RepoType repoType;
    private final FormatType formatType;
    private final String displayStyle;
    private final String resultsCount;
    private final String filterRegex;
    private final String sortOrder;
    private final boolean hideTextarea;

    public Map<String, String> getResult() {
        return Connector.getInstance(this).getResults().entrySet().stream().filter(ArtifactRepoParamDefinition.distinctByValue(Map.Entry::getValue)).filter(entry -> ((String)entry.getValue()).matches(this.filterRegex)).sorted(this.getComparator()).limit(Integer.parseInt(this.resultsCount)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static <T> Predicate<T> distinctByValue(Function<? super T, ?> func) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(func.apply(t), Boolean.TRUE) == null;
    }

    private Comparator<Map.Entry<String, String>> getComparator() {
        Comparator<Map.Entry<String, String>> comparator = Map.Entry.comparingByValue(new AlphanumComparator());
        if ("desc".equals(this.sortOrder)) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    ArtifactRepoParamDefinition(String serverType, String serverUrl, String credentialsId, boolean ignoreCertificate, ArtifactRepoParamProxy proxy) {
        this("Connection Validation", null, serverType, serverUrl, credentialsId, ignoreCertificate, proxy, "test", null, null, null, RepoType.testValue(), FormatType.testValue(), null, null, null, null, false);
    }

    @DataBoundConstructor
    public ArtifactRepoParamDefinition(String name, String description, String serverType, String serverUrl, String credentialsId, boolean ignoreCertificate, ArtifactRepoParamProxy proxy, String paramType, String artifactName, String repoName, String versionRegex, String[] repoType, String[] formatType, String displayStyle, String resultsCount, String filterRegex, String sortOrder, boolean hideTextarea) {
        super(name, description);
        this.serverType = Optional.ofNullable(serverType).map(String::trim).orElse(null);
        this.serverUrl = Optional.ofNullable(serverUrl).map(String::trim).orElse(null);
        this.credentialsId = Optional.ofNullable(credentialsId).map(String::trim).orElse(null);
        this.ignoreCertificate = ignoreCertificate;
        this.proxy = Optional.ofNullable(proxy).orElse(ArtifactRepoParamProxy.DISABLED);
        this.paramType = Optional.ofNullable(paramType).map(String::trim).orElse(null);
        this.artifactName = Optional.ofNullable(artifactName).map(String::trim).orElse(null);
        this.repoName = Optional.ofNullable(repoName).map(String::trim).orElse(null);
        this.versionRegex = Optional.ofNullable(versionRegex).map(String::trim).orElse(null);
        this.repoType = new RepoType(repoType);
        this.formatType = new FormatType(formatType);
        this.displayStyle = Optional.ofNullable(displayStyle).map(String::trim).orElse(null);
        this.resultsCount = Optional.ofNullable(resultsCount).filter(StringUtils::isNotBlank).filter(s -> s.matches("\\d+")).orElse("10");
        this.filterRegex = Optional.ofNullable(filterRegex).map(String::trim).orElse(null);
        this.sortOrder = Optional.ofNullable(sortOrder).map(String::trim).orElse(null);
        this.hideTextarea = hideTextarea;
    }

    public String getProxyCredentialsId() {
        return this.proxy.getProxyCredentialsId();
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject json) {
        Object jsonValue = json.get("value");
        String name = Optional.ofNullable(json.getString("name")).orElse("MISSING");
        String value = "";
        if (jsonValue instanceof String) {
            value = (String)jsonValue;
        } else if (jsonValue instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)jsonValue;
            value = jsonArray.stream().map(Object::toString).collect(Collectors.joining("\\n"));
        }
        return new StringParameterValue(name, value, this.getDescription());
    }

    public ParameterValue createValue(StaplerRequest request) {
        Object[] values = request.getParameterValues(this.getName());
        if (ArrayUtils.isEmpty((Object[])values) || StringUtils.isBlank((String)values[0])) {
            return null;
        }
        Object value = values[0];
        return new StringParameterValue(this.getName(), (String)value, this.getDescription());
    }

    public String getUid() {
        return this.uid;
    }

    public String getServerType() {
        return this.serverType;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public ArtifactRepoParamProxy getProxy() {
        return this.proxy;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public boolean isIgnoreCertificate() {
        return this.ignoreCertificate;
    }

    public String getParamType() {
        return this.paramType;
    }

    public String getArtifactName() {
        return this.artifactName;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getVersionRegex() {
        return this.versionRegex;
    }

    public RepoType getRepoType() {
        return this.repoType;
    }

    public FormatType getFormatType() {
        return this.formatType;
    }

    public String getDisplayStyle() {
        return this.displayStyle;
    }

    public String getResultsCount() {
        return this.resultsCount;
    }

    public String getFilterRegex() {
        return this.filterRegex;
    }

    public String getSortOrder() {
        return this.sortOrder;
    }

    public boolean isHideTextarea() {
        return this.hideTextarea;
    }

    @Extension
    public static class DescriptorImpl
    extends ArtifactRepoParamDescriptor {
    }
}

