/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.impl.SecurityWarning;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Plugin {
    private String name;
    private VersionNumber version;
    private String groupId;
    private String url;
    private File file;
    private List<Plugin> dependencies;
    private boolean dependenciesSpecified;
    private Plugin parent;
    private List<SecurityWarning> securityWarnings;
    private boolean latest;
    private boolean experimental;
    private boolean optional;
    private String sha256Checksum;
    private VersionNumber jenkinsVersion;

    public Plugin(String name, String version, String url, String groupId) {
        this.name = name;
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "latest";
        }
        this.version = new VersionNumber(version);
        this.url = url;
        this.dependencies = new ArrayList<Plugin>();
        this.parent = this;
        this.groupId = groupId;
        this.securityWarnings = new ArrayList<SecurityWarning>();
        if (version.equals("latest")) {
            this.latest = true;
        }
        if (version.equals("experimental")) {
            this.experimental = true;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(VersionNumber version) {
        this.version = version;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setJenkinsVersion(String jenkinsVersion) {
        this.jenkinsVersion = new VersionNumber(jenkinsVersion);
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    public String getSha256Checksum() {
        return this.sha256Checksum;
    }

    public void setSha256Checksum(String sha256Checksum) {
        this.sha256Checksum = sha256Checksum;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArchiveFileName() {
        return this.name + ".jpi";
    }

    public File getFile() {
        return this.file;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setDependencies(List<Plugin> dependencies) {
        this.dependencies = dependencies;
        this.dependenciesSpecified = true;
    }

    public Plugin withDependencies(List<Plugin> dependencies) {
        this.setDependencies(dependencies);
        return this;
    }

    public Plugin withoutDependencies() {
        this.setDependencies(Collections.emptyList());
        return this;
    }

    public List<Plugin> getDependencies() {
        return this.dependencies;
    }

    public boolean isDependenciesSpecified() {
        return this.dependenciesSpecified;
    }

    public void setParent(Plugin parent) {
        this.parent = parent;
    }

    public Plugin getParent() {
        return this.parent;
    }

    public Plugin setOptional(boolean optional) {
        this.optional = optional;
        return this;
    }

    public boolean getOptional() {
        return this.optional;
    }

    public VersionNumber getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    public void setSecurityWarnings(List<SecurityWarning> securityWarnings) {
        this.securityWarnings = securityWarnings;
    }

    public List<SecurityWarning> getSecurityWarnings() {
        return this.securityWarnings;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public String toString() {
        if (this.url == null) {
            return this.name + " " + this.version;
        }
        return this.name + " " + this.version + " " + this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name) && Objects.equals(this.version, plugin.version) && Objects.equals(this.groupId, plugin.groupId) && Objects.equals(this.url, plugin.url) && Objects.equals(this.optional, plugin.optional);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.groupId, this.url);
    }
}

