/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.impl.DownloadPluginException;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;

public class ManifestTools {
    public static Plugin readPluginFromFile(File file) throws IOException {
        Plugin plugin = new Plugin(file.getName(), "undefined", null, null);
        String version = ManifestTools.getAttributeFromManifest(file, "Plugin-Version");
        if (!StringUtils.isEmpty((CharSequence)version)) {
            plugin.setVersion(new VersionNumber(version));
        }
        plugin.setJenkinsVersion(ManifestTools.getAttributeFromManifest(file, "Jenkins-Version"));
        String dependencyString = ManifestTools.getAttributeFromManifest(file, "Plugin-Dependencies");
        if (StringUtils.isEmpty((CharSequence)dependencyString)) {
            return plugin;
        }
        String[] dependencies = dependencyString.split(",");
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        for (String dependency : dependencies) {
            if (dependency.contains("resolution:=optional")) continue;
            String[] pluginInfo = dependency.split(":");
            String pluginName = pluginInfo[0];
            String pluginVersion = pluginInfo[1];
            Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, null, null);
            dependentPlugins.add(dependentPlugin);
            dependentPlugin.setParent(plugin);
        }
        plugin.setDependencies(dependentPlugins);
        return plugin;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAttributeFromManifest(File file, String key) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(key);
            return string;
        }
        catch (IOException e) {
            System.out.println("Unable to open " + file);
            if (!key.equals("Plugin-Dependencies")) return null;
            throw new DownloadPluginException("Unable to determine plugin dependencies", e);
        }
    }
}

