/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.jenkins.tools.pluginmanager.config.PluginInputException;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import io.jenkins.tools.pluginmanager.util.PluginInfo;
import io.jenkins.tools.pluginmanager.util.Plugins;
import io.jenkins.tools.pluginmanager.util.Source;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PluginListParser {
    private static final ObjectMapper MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER)).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final boolean verbose;

    public PluginListParser(boolean verbose) {
        this.verbose = verbose;
    }

    public List<Plugin> parsePluginsFromCliOption(String[] plugins) {
        if (plugins == null) {
            return new ArrayList<Plugin>();
        }
        return Arrays.stream(plugins).map(this::parsePluginLine).collect(Collectors.toList());
    }

    public List<Plugin> parsePluginTxtFile(File pluginTxtFile) {
        ArrayList<Plugin> pluginsFromTxt = new ArrayList<Plugin>();
        if (this.fileExists(pluginTxtFile)) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(pluginTxtFile.toPath(), StandardCharsets.UTF_8);){
                List pluginsFromFile = bufferedReader.lines().map(line -> line.replaceAll("\\s#+.*", "")).map(line -> line.replaceAll("\\s", "")).filter(line -> !line.startsWith("#")).filter(line -> line.length() > 0).map(this::parsePluginLine).collect(Collectors.toList());
                pluginsFromTxt.addAll(pluginsFromFile);
            }
            catch (IOException e) {
                System.err.println("Unable to open " + String.valueOf(pluginTxtFile));
            }
        }
        return pluginsFromTxt;
    }

    public List<Plugin> parsePluginYamlFile(File pluginYamlFile) {
        ArrayList<Plugin> pluginsFromYaml = new ArrayList<Plugin>();
        if (this.fileExists(pluginYamlFile)) {
            try (FileInputStream inputStream = new FileInputStream(pluginYamlFile);){
                Plugins plugins = (Plugins)MAPPER.readValue((InputStream)inputStream, Plugins.class);
                for (PluginInfo pluginInfo : plugins.getPlugins()) {
                    Plugin plugin;
                    String name = pluginInfo.getArtifactId();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        throw new PluginInputException("ArtifactId is required");
                    }
                    String groupId = pluginInfo.getGroupId();
                    Source pluginSource = pluginInfo.getSource();
                    if (pluginSource == null && StringUtils.isNotEmpty((CharSequence)groupId)) {
                        throw new PluginInputException("Version must be input for " + name);
                    }
                    if (pluginSource == null) {
                        plugin = new Plugin(name, "latest", null, null);
                    } else {
                        String url;
                        String version = pluginSource.getVersion();
                        if (StringUtils.isNotEmpty((CharSequence)groupId) && version == null) {
                            throw new PluginInputException("Version must be input for " + name);
                        }
                        if (version == null) {
                            version = "latest";
                        }
                        if (!PluginListParser.isURL(url = pluginSource.getUrl())) {
                            url = null;
                        }
                        plugin = new Plugin(name, version, url, groupId);
                    }
                    pluginsFromYaml.add(plugin);
                }
            }
            catch (IOException e) {
                System.err.println("Unable to open " + String.valueOf(pluginsFromYaml));
                e.printStackTrace();
            }
        }
        return pluginsFromYaml;
    }

    public boolean fileExists(File pluginFile) {
        if (pluginFile == null) {
            return false;
        }
        if (Files.exists(pluginFile.toPath(), new LinkOption[0])) {
            if (this.verbose) {
                System.err.println("Reading in plugins from " + String.valueOf(pluginFile) + "\n");
            }
            return true;
        }
        System.err.println(String.valueOf(pluginFile) + " file does not exist");
        return false;
    }

    private Plugin parsePluginLine(String pluginLine) {
        String[] pluginInfo = pluginLine.split(":", 3);
        String pluginName = pluginInfo[0];
        String pluginVersion = "latest";
        String pluginUrl = null;
        String groupId = null;
        if (pluginInfo.length >= 2 && (pluginVersion = pluginInfo[1]).contains("incrementals")) {
            String[] incrementalsVersionInfo = pluginVersion.split(";");
            groupId = incrementalsVersionInfo[1];
            pluginVersion = incrementalsVersionInfo[2];
        }
        if (pluginInfo.length >= 3) {
            if (PluginListParser.isURL(pluginInfo[2])) {
                pluginUrl = pluginInfo[2];
            } else {
                System.err.println("Invalid URL " + pluginInfo[2] + " , will ignore");
            }
        }
        return new Plugin(pluginName, pluginVersion, pluginUrl, groupId);
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

