/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import io.jenkins.tools.pluginmanager.util.URIStringBuilder;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class PluginManagerUtils {
    private PluginManagerUtils() {
    }

    public static String appendPathOntoUrl(Object urlString, Object ... pathSection) {
        String[] args = new String[pathSection.length];
        for (int i = 0; i < pathSection.length; ++i) {
            Objects.requireNonNull(pathSection[i]);
            args[i] = pathSection[i].toString();
        }
        return PluginManagerUtils.appendPathOntoUrl(urlString.toString(), args);
    }

    public static String appendPathOntoUrl(String urlString, String ... pathSection) {
        return new URIStringBuilder(urlString).addPath(pathSection).build();
    }

    public static String removePossibleWrapperText(String urlText) {
        Pattern pattern;
        Matcher matcher;
        if (urlText != null && urlText.startsWith("updateCenter.post(") && (matcher = (pattern = Pattern.compile("updateCenter.post\\((.*)\\);", 32)).matcher(urlText)).find()) {
            return matcher.group(1);
        }
        return urlText;
    }

    public static String dirName(Object urlString) {
        Objects.requireNonNull(urlString);
        return PluginManagerUtils.dirName(urlString.toString());
    }

    public static String dirName(String urlString) {
        int lastSlashCol = urlString.lastIndexOf(47);
        if (lastSlashCol > 0 && urlString.charAt(lastSlashCol - 1) != '/') {
            return urlString.substring(0, lastSlashCol + 1);
        }
        return urlString;
    }

    public static String removePath(Object urlString) {
        Objects.requireNonNull(urlString);
        return PluginManagerUtils.removePath(urlString.toString());
    }

    public static String removePath(String urlString) {
        String lastUrlString;
        do {
            lastUrlString = urlString;
            if (!(urlString = PluginManagerUtils.dirName(urlString)).endsWith("/")) continue;
            urlString = urlString.substring(0, urlString.length() - 1);
        } while (!urlString.equals(lastUrlString));
        return urlString;
    }

    public static String insertPathPreservingFilename(Object urlString, Object pathToInsert) {
        Objects.requireNonNull(urlString);
        Objects.requireNonNull(pathToInsert);
        return PluginManagerUtils.insertPathPreservingFilename(urlString.toString(), pathToInsert.toString());
    }

    public static String insertPathPreservingFilename(String urlString, String pathToInsert) {
        int lastSlashCol = urlString.lastIndexOf(47);
        if (lastSlashCol >= 0) {
            return PluginManagerUtils.appendPathOntoUrl(urlString.substring(0, lastSlashCol + 1), pathToInsert, urlString.substring(lastSlashCol + 1));
        }
        return PluginManagerUtils.appendPathOntoUrl(pathToInsert, urlString);
    }
}

