/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.util;

import io.jenkins.tools.pluginmanager.config.PluginInputException;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class PluginListParser {
    public List<Plugin> parsePluginsFromCliOption(String[] plugins) {
        if (plugins == null) {
            return new ArrayList<Plugin>();
        }
        return Arrays.stream(plugins).map(this::parsePluginLine).collect(Collectors.toList());
    }

    public List<Plugin> parsePluginTxtFile(File pluginTxtFile) {
        ArrayList<Plugin> pluginsFromTxt = new ArrayList<Plugin>();
        if (this.fileExists(pluginTxtFile)) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(pluginTxtFile.toPath(), StandardCharsets.UTF_8);){
                List pluginsFromFile = bufferedReader.lines().map(line -> line.replaceAll("\\s#+.*", "")).map(line -> line.replaceAll("\\s", "")).filter(line -> !line.startsWith("#")).filter(line -> line.length() > 0).map(this::parsePluginLine).collect(Collectors.toList());
                pluginsFromTxt.addAll(pluginsFromFile);
            }
            catch (IOException e) {
                System.out.println("Unable to open " + pluginTxtFile);
            }
        }
        return pluginsFromTxt;
    }

    public List<Plugin> parsePluginYamlFile(File pluginYamlFile) {
        ArrayList<Plugin> pluginsFromYaml = new ArrayList<Plugin>();
        if (this.fileExists(pluginYamlFile)) {
            Yaml yaml = new Yaml();
            try (FileInputStream inputStream = new FileInputStream(pluginYamlFile);){
                Map map = (Map)yaml.load((InputStream)inputStream);
                List plugins = (List)map.get("plugins");
                for (Object p : plugins) {
                    Plugin plugin;
                    String name;
                    Map pluginInfo = (Map)p;
                    Object nameObject = pluginInfo.get("artifactId");
                    String string = name = nameObject == null ? null : nameObject.toString();
                    if (StringUtils.isEmpty((CharSequence)name)) {
                        throw new PluginInputException("ArtifactId is required");
                    }
                    Object groupIdObject = pluginInfo.get("groupId");
                    String groupId = groupIdObject == null ? null : groupIdObject.toString();
                    Map pluginSource = (Map)pluginInfo.get("source");
                    Object incrementalsVersion = null;
                    if (pluginSource == null && !StringUtils.isEmpty((CharSequence)groupId)) {
                        throw new PluginInputException("Version must be input for " + name);
                    }
                    if (pluginSource == null) {
                        plugin = new Plugin(name, "latest", null, null);
                    } else {
                        Object versionObject = pluginSource.get("version");
                        if (!StringUtils.isEmpty((CharSequence)groupId) && versionObject == null) {
                            throw new PluginInputException("Version must be input for " + name);
                        }
                        String version = versionObject == null ? "latest" : versionObject.toString();
                        Object urlObject = pluginSource.get("url");
                        String url = urlObject != null && PluginListParser.isURL(urlObject.toString()) ? urlObject.toString() : null;
                        plugin = new Plugin(name, version, url, groupId);
                    }
                    pluginsFromYaml.add(plugin);
                }
            }
            catch (IOException e) {
                System.out.println("Unable to open " + pluginsFromYaml);
            }
        }
        return pluginsFromYaml;
    }

    public boolean fileExists(File pluginFile) {
        if (pluginFile == null) {
            return false;
        }
        if (Files.exists(pluginFile.toPath(), new LinkOption[0])) {
            System.out.println("Reading in plugins from " + pluginFile + "\n");
            return true;
        }
        System.out.println(pluginFile + " file does not exist");
        return false;
    }

    private Plugin parsePluginLine(String pluginLine) {
        String[] pluginInfo = pluginLine.split(":", 3);
        String pluginName = pluginInfo[0];
        String pluginVersion = "latest";
        String pluginUrl = null;
        String groupId = null;
        if (pluginInfo.length >= 2 && (pluginVersion = pluginInfo[1]).contains("incrementals")) {
            String[] incrementalsVersionInfo = pluginVersion.split(";");
            groupId = incrementalsVersionInfo[1];
            pluginVersion = incrementalsVersionInfo[2];
        }
        if (pluginInfo.length >= 3) {
            if (PluginListParser.isURL(pluginInfo[2])) {
                pluginUrl = pluginInfo[2];
            } else {
                System.out.println("Invalid URL " + pluginInfo[2] + " , will ignore");
            }
        }
        return new Plugin(pluginName, pluginVersion, pluginUrl, groupId);
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

