/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;
import org.json.JSONObject;

public class CacheManager {
    private Path cache;
    private boolean verbose;

    public CacheManager(Path cache, boolean verbose) {
        this.cache = cache;
        this.verbose = verbose;
    }

    void createCache() {
        if (!Files.exists(this.cache, new LinkOption[0])) {
            try {
                Files.createDirectory(this.cache, new FileAttribute[0]);
                if (this.verbose) {
                    System.out.println("Created cache at: " + this.cache);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    void addToCache(String cacheKey, String value) {
        try {
            Path fileToCache = this.cache.resolve(cacheKey + ".json");
            Files.write(fileToCache, value.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    JSONObject retrieveFromCache(String cacheKey) {
        Path cachedPath = this.cache.resolve(cacheKey + ".json");
        if (!Files.exists(cachedPath, new LinkOption[0])) {
            return null;
        }
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(cachedPath, new LinkOption[0]);
            Duration between = Duration.between(lastModifiedTime.toInstant(), Instant.now());
            long betweenHours = between.toHours();
            if (betweenHours > 0L) {
                if (this.verbose) {
                    System.out.println("Cache entry expired");
                }
                return null;
            }
            return new JSONObject(new String(Files.readAllBytes(cachedPath), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

