/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.config.Config;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import io.jenkins.tools.pluginmanager.impl.SecurityWarning;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginManager {
    private List<Plugin> plugins;
    private List<Plugin> failedPlugins;
    private File refDir;
    private String jenkinsUcLatest = "";
    private VersionNumber jenkinsVersion;
    private File jenkinsWarFile;
    private Map<String, VersionNumber> installedPluginVersions;
    private Map<String, VersionNumber> bundledPluginVersions;
    private List<SecurityWarning> allSecurityWarnings;
    private Config cfg;
    private JSONObject latestUcJson;
    private JSONObject experimentalUcJson;
    private JSONObject pluginInfoJson;
    public static final String SEPARATOR = File.separator;

    public PluginManager(Config cfg) {
        this.cfg = cfg;
        this.plugins = cfg.getPlugins();
        this.refDir = cfg.getPluginDir();
        this.jenkinsWarFile = new File(cfg.getJenkinsWar());
        this.failedPlugins = new ArrayList<Plugin>();
        this.installedPluginVersions = new HashMap<String, VersionNumber>();
        this.bundledPluginVersions = new HashMap<String, VersionNumber>();
        this.allSecurityWarnings = new ArrayList<SecurityWarning>();
    }

    public void start() {
        if (!this.refDir.exists()) {
            try {
                Files.createDirectory(this.refDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                System.out.println("Unable to create plugin directory");
            }
        }
        this.jenkinsVersion = this.getJenkinsVersionFromWar();
        this.checkAndSetLatestUpdateCenter();
        this.getUCJson();
        this.getSecurityWarnings();
        this.showAllSecurityWarnings();
        this.bundledPlugins();
        this.installedPlugins();
        this.downloadPlugins(this.plugins);
        this.outputFailedPlugins();
    }

    public void getSecurityWarnings() {
        if (this.latestUcJson == null) {
            System.out.println("Unable to get update center json");
            return;
        }
        JSONArray warnings = this.latestUcJson.getJSONArray("warnings");
        for (int i = 0; i < warnings.length(); ++i) {
            JSONObject warning = warnings.getJSONObject(i);
            String warningType = warning.getString("type");
            if (!warningType.equals("plugin")) continue;
            String warningId = warning.getString("id");
            String warningMessage = warning.getString("message");
            String warningName = warning.getString("name");
            String warningUrl = warning.getString("url");
            SecurityWarning securityWarning = new SecurityWarning(warningId, warningMessage, warningName, warningUrl);
            JSONArray warningVersions = warning.getJSONArray("versions");
            for (int j = 0; j < warningVersions.length(); ++j) {
                JSONObject warningVersion = warningVersions.getJSONObject(j);
                String lastVersion = "";
                if (warningVersion.has("lastVersion")) {
                    lastVersion = warningVersion.getString("lastVersion");
                }
                String pattern = warningVersion.getString("pattern");
                securityWarning.addSecurityVersion(lastVersion, pattern);
            }
            this.allSecurityWarnings.add(securityWarning);
        }
    }

    public void showAllSecurityWarnings() {
        if (this.cfg.isShowAllWarnings()) {
            for (int i = 0; i < this.allSecurityWarnings.size(); ++i) {
                SecurityWarning securityWarning = this.allSecurityWarnings.get(i);
                System.out.println(securityWarning.getName() + " - " + securityWarning.getMessage());
            }
        }
    }

    public void checkAndSetLatestUpdateCenter() {
        if (this.jenkinsVersion == null || !StringUtils.isEmpty((CharSequence)this.jenkinsVersion.toString())) {
            this.jenkinsUcLatest = this.cfg.getJenkinsUc() + "/" + this.jenkinsVersion;
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpGet httpget = new HttpGet(this.jenkinsUcLatest);
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);){
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.jenkinsUcLatest = this.cfg.getJenkinsUc().toString();
                    }
                }
                catch (IOException e) {
                    this.jenkinsUcLatest = this.cfg.getJenkinsUc().toString();
                    System.out.println("No version specific update center for Jenkins version " + this.jenkinsVersion);
                }
            }
            catch (IOException e) {
                this.jenkinsUcLatest = this.cfg.getJenkinsUc().toString();
                System.out.println("Unable to check if version specific update center for Jenkins version " + this.jenkinsVersion);
            }
        }
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    public void outputFailedPlugins() {
        if (this.failedPlugins.size() > 0) {
            System.out.println("Some plugins failed to download: ");
            this.failedPlugins.stream().map(p -> p.getOriginalName() + " or " + p.getName()).forEach(System.out::println);
            System.exit(1);
        }
        System.exit(0);
    }

    public void downloadPlugins(List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            boolean successfulDownload = this.downloadPlugin(plugin);
            if (successfulDownload) continue;
            System.out.println("Unable to download " + plugin.getName() + ". Skipping...");
            this.failedPlugins.add(plugin);
        }
    }

    public JSONObject getJson(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            String urlText = IOUtils.toString((URL)url, (Charset)Charset.forName("UTF-8"));
            JSONObject updateCenterJson = new JSONObject(urlText);
            return updateCenterJson;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void getUCJson() {
        this.latestUcJson = this.getJson(this.jenkinsUcLatest + "/update-center.actual.json");
        this.experimentalUcJson = this.getJson(this.cfg.getJenkinsUcExperimental() + "/update-center.actual.json");
        this.pluginInfoJson = this.getJson("https://updates.jenkins.io/current/plugin-versions.json");
    }

    public JSONArray getPluginDependencyJsonArray(Plugin plugin, JSONObject ucJson) {
        JSONObject plugins = ucJson.getJSONObject("plugins");
        JSONObject pluginInfo = (JSONObject)plugins.get(plugin.getName());
        if (ucJson.equals(this.pluginInfoJson)) {
            if (pluginInfo.has(plugin.getVersion().toString())) {
                JSONObject specificVersionInfo = pluginInfo.getJSONObject(plugin.getVersion().toString());
                return (JSONArray)specificVersionInfo.get("dependencies");
            }
        } else {
            return (JSONArray)pluginInfo.get("dependencies");
        }
        return null;
    }

    public void resolveDependenciesFromManifest(Plugin plugin) {
        String dependencyString = this.getAttributefromManifest(plugin.getFile(), "Plugin-Dependencies");
        String[] dependencies = dependencyString.split(",");
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        System.out.println(plugin.getName() + " depends on: ");
        boolean isPluginOptional = false;
        for (String dependency : dependencies) {
            if (dependency.contains("resolution:=optional")) {
                dependency = dependency.split(";")[0];
                isPluginOptional = true;
            }
            String[] pluginInfo = dependency.split(":");
            String pluginName = pluginInfo[0];
            String pluginVersion = pluginInfo[1];
            Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, isPluginOptional);
            dependentPlugins.add(dependentPlugin);
            System.out.println(pluginName + ": " + pluginVersion);
        }
        this.downloadDependencies(dependentPlugins);
    }

    public void resolveDependencies(Plugin plugin) {
        JSONArray dependencies = null;
        String version = plugin.getVersion().toString();
        if (!StringUtils.isEmpty((CharSequence)plugin.getUrl()) || version.contains("incrementals")) {
            this.resolveDependenciesFromManifest(plugin);
        } else {
            dependencies = version.equals("latest") ? this.getPluginDependencyJsonArray(plugin, this.latestUcJson) : (version.equals("experimental") ? this.getPluginDependencyJsonArray(plugin, this.experimentalUcJson) : this.getPluginDependencyJsonArray(plugin, this.pluginInfoJson));
        }
        if (dependencies == null) {
            this.resolveDependenciesFromManifest(plugin);
            return;
        }
        if (dependencies.length() == 0) {
            System.out.println(plugin.getName() + " has no dependencies");
            return;
        }
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        System.out.println(plugin.getName() + " depends on: ");
        for (int i = 0; i < dependencies.length(); ++i) {
            JSONObject dependency = dependencies.getJSONObject(i);
            String pluginName = dependency.getString("name");
            String pluginVersion = dependency.getString("version");
            boolean isPluginOptional = dependency.getBoolean("optional");
            Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, isPluginOptional);
            dependentPlugins.add(dependentPlugin);
            System.out.println(pluginName + ": " + pluginVersion);
        }
        this.downloadDependencies(dependentPlugins);
    }

    public void downloadDependencies(List<Plugin> dependentPlugins) {
        for (Plugin dependency : dependentPlugins) {
            String dependencyName = dependency.getName();
            VersionNumber dependencyVersion = dependency.getVersion();
            if (dependency.getPluginOptional()) {
                System.out.println("Skipping optional dependency " + dependencyName);
                continue;
            }
            VersionNumber installedVersion = null;
            if (this.installedPluginVersions.containsKey(dependencyName)) {
                installedVersion = this.installedPluginVersions.get(dependencyName);
            } else if (this.bundledPluginVersions.containsKey(dependencyName)) {
                installedVersion = this.bundledPluginVersions.get(dependencyName);
            }
            if (installedVersion != null) {
                if (installedVersion.compareTo(dependencyVersion) < 0) {
                    System.out.println("Installed version (" + installedVersion + ") of " + dependencyName + " is less than minimum required version of " + dependencyVersion + ", upgrading bundled dependency");
                    this.downloadPlugin(dependency);
                    continue;
                }
                System.out.println("Skipping already installed dependency " + dependencyName);
                continue;
            }
            this.downloadPlugin(dependency);
        }
    }

    public boolean downloadPlugin(Plugin plugin) {
        String pluginName = plugin.getName();
        VersionNumber pluginVersion = plugin.getVersion();
        if (this.installedPluginVersions.containsKey(pluginName) && this.installedPluginVersions.get(pluginName).compareTo(pluginVersion) == 0) {
            System.out.println(pluginName + " already installed, skipping");
            return true;
        }
        String pluginDownloadUrl = this.getPluginDownloadUrl(plugin);
        boolean successfulDownload = this.downloadToFile(pluginDownloadUrl, plugin);
        if (!successfulDownload) {
            String newPluginName = plugin.getName() + "-plugin";
            plugin.setName(newPluginName);
            pluginDownloadUrl = this.getPluginDownloadUrl(plugin);
            successfulDownload = this.downloadToFile(pluginDownloadUrl, plugin);
        }
        if (successfulDownload) {
            System.out.println("downloaded successful");
            this.installedPluginVersions.put(plugin.getName(), pluginVersion);
            this.resolveDependencies(plugin);
        }
        return successfulDownload;
    }

    public String getPluginDownloadUrl(Plugin plugin) {
        String pluginName = plugin.getName();
        String pluginVersion = plugin.getVersion().toString();
        String pluginUrl = plugin.getUrl();
        String urlString = "";
        if (StringUtils.isEmpty((CharSequence)pluginVersion)) {
            pluginVersion = "latest";
        }
        if (!StringUtils.isEmpty((CharSequence)pluginUrl)) {
            System.out.println("Will use url: " + pluginUrl);
            urlString = pluginUrl;
        } else if (pluginVersion.equals("latest") && !StringUtils.isEmpty((CharSequence)this.jenkinsUcLatest)) {
            urlString = String.format("%s/latest/%s.hpi", this.jenkinsUcLatest, pluginName);
        } else if (pluginVersion.equals("experimental")) {
            urlString = String.format("%s/latest/%s.hpi", this.cfg.getJenkinsUcExperimental(), pluginName);
        } else if (pluginVersion.contains("incrementals")) {
            System.out.println("plugin version " + pluginVersion);
            String[] incrementalsVersionInfo = pluginVersion.split(";");
            String groupId = incrementalsVersionInfo[1];
            String incrementalsVersion = incrementalsVersionInfo[2];
            groupId = groupId.replace(".", "/");
            String incrementalsVersionPath = String.format("%s/%s-%s.hpi", incrementalsVersion, pluginName, incrementalsVersion);
            urlString = String.format("%s/%s/%s", this.cfg.getJenkinsIncrementalsRepoMirror(), groupId, incrementalsVersionPath);
        } else {
            urlString = String.format("%s/download/plugins/%s/%s/%s.hpi", this.cfg.getJenkinsUc(), pluginName, pluginVersion, pluginName);
        }
        return urlString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadToFile(String urlString, Plugin plugin) {
        Throwable throwable;
        System.out.println("\nDownloading plugin " + plugin.getName() + " from url: " + urlString);
        File pluginFile = new File(this.refDir + SEPARATOR + plugin.getArchiveFileName());
        try {
            throwable = null;
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpClientContext context = HttpClientContext.create();
                HttpGet httpget = new HttpGet(urlString);
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget, (HttpContext)context);){
                    HttpHost target = context.getTargetHost();
                    List redirectLocations = context.getRedirectLocations();
                    URI location = URIUtils.resolve((URI)httpget.getURI(), (HttpHost)target, (List)redirectLocations);
                    FileUtils.copyURLToFile((URL)location.toURL(), (File)pluginFile);
                }
                catch (IOException | URISyntaxException e) {
                    System.out.println("Unable to resolve plugin URL or download plugin to file");
                    boolean bl = false;
                    if (httpclient == null) return bl;
                    if (throwable == null) {
                        httpclient.close();
                        return bl;
                    }
                    try {
                        httpclient.close();
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return bl;
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to create HTTP connection to download plugin");
            return false;
        }
        try {
            throwable = null;
            try (JarFile pluginJpi = new JarFile(pluginFile);){
                plugin.setFile(pluginFile);
                return true;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (IOException e) {
            this.failedPlugins.add(plugin);
            System.out.println("Downloaded file is not a valid ZIP");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAttributefromManifest(File file, String key) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(key);
            return string;
        }
        catch (IOException e) {
            System.out.println("Unable to open " + file);
            return null;
        }
    }

    public VersionNumber getJenkinsVersionFromWar() {
        String version = this.getAttributefromManifest(this.jenkinsWarFile, "Jenkins-Version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            System.out.println("Unable to get version from war file");
            return null;
        }
        return new VersionNumber(version);
    }

    public String getPluginVersion(File file) {
        String version = this.getAttributefromManifest(file, "Plugin-Version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            System.out.println("Unable to get plugin version from " + file);
            return "";
        }
        return version;
    }

    public List<String> installedPlugins() {
        ArrayList<String> installedPlugins = new ArrayList<String>();
        WildcardFileFilter fileFilter = new WildcardFileFilter("*.jpi");
        System.out.println("\nInstalled plugins: ");
        File[] files = this.refDir.listFiles((FileFilter)fileFilter);
        if (files != null) {
            for (File file : files) {
                String pluginName = FilenameUtils.getBaseName((String)file.getName());
                VersionNumber pluginVersion = new VersionNumber(this.getPluginVersion(file));
                this.installedPluginVersions.put(pluginName, pluginVersion);
                installedPlugins.add(pluginName);
                System.out.println(pluginName);
            }
        }
        return installedPlugins;
    }

    public List<String> bundledPlugins() {
        ArrayList<String> bundledPlugins = new ArrayList<String>();
        if (this.jenkinsWarFile.exists()) {
            URI jenkinsWarUri;
            Path path = Paths.get(this.jenkinsWarFile.toString(), new String[0]);
            try {
                jenkinsWarUri = new URI("jar:" + path.toUri());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return bundledPlugins;
            }
            try (FileSystem warFS = FileSystems.newFileSystem(jenkinsWarUri, Collections.emptyMap());){
                Path warPath = warFS.getPath("/", new String[0]).getRoot();
                PathMatcher matcher = warFS.getPathMatcher("regex:.*[^detached-]plugins.*\\.\\w+pi");
                Stream<Path> walk = Files.walk(warPath, new FileVisitOption[0]);
                System.out.println("\nWar bundled plugins: ");
                Iterator it = walk.iterator();
                while (it.hasNext()) {
                    Path fileName;
                    Path file = (Path)it.next();
                    if (!matcher.matches(file) || (fileName = file.getFileName()) == null) continue;
                    bundledPlugins.add(fileName.toString());
                    System.out.println(fileName.toString());
                    InputStream in = Files.newInputStream(file, new OpenOption[0]);
                    Path tempFile = Files.createTempFile("PREFIX", "SUFFIX", new FileAttribute[0]);
                    try (FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                        IOUtils.copy((InputStream)in, (OutputStream)out);
                    }
                    VersionNumber pluginVersion = new VersionNumber(this.getPluginVersion(tempFile.toFile()));
                    Files.delete(tempFile);
                    this.bundledPluginVersions.put(FilenameUtils.getBaseName((String)fileName.toString()), pluginVersion);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("War not found, installing all plugins: " + this.jenkinsWarFile.toString());
        }
        return bundledPlugins;
    }

    public void setJenkinsVersion(VersionNumber jenkinsVersion) {
        this.jenkinsVersion = jenkinsVersion;
    }

    public VersionNumber getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    public String getJenkinsUCLatest() {
        return this.jenkinsUcLatest;
    }

    public void setJenkinsUCLatest(String updateCenterLatest) {
        this.jenkinsUcLatest = updateCenterLatest;
    }
}

