/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.config.Config;
import io.jenkins.tools.pluginmanager.impl.DirectoryCreationException;
import io.jenkins.tools.pluginmanager.impl.DownloadPluginException;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import io.jenkins.tools.pluginmanager.impl.PluginDependencyStrategyException;
import io.jenkins.tools.pluginmanager.impl.PluginNotFoundException;
import io.jenkins.tools.pluginmanager.impl.SecurityWarning;
import io.jenkins.tools.pluginmanager.impl.UpdateCenterInfoRetrievalException;
import io.jenkins.tools.pluginmanager.impl.VersionCompatibilityException;
import io.jenkins.tools.pluginmanager.impl.WarBundledPluginException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.json.JSONArray;
import org.json.JSONObject;

public class PluginManager {
    private List<Plugin> failedPlugins;
    private File refDir;
    private String jenkinsUcLatest;
    private VersionNumber jenkinsVersion;
    private File jenkinsWarFile;
    private Map<String, Plugin> installedPluginVersions;
    private Map<String, Plugin> bundledPluginVersions;
    private Map<String, List<SecurityWarning>> allSecurityWarnings;
    private Map<String, Plugin> allPluginsAndDependencies;
    private Map<String, Plugin> effectivePlugins;
    private List<Plugin> pluginsToBeDownloaded;
    private Config cfg;
    private JSONObject latestUcJson;
    private JSONObject experimentalUcJson;
    private JSONObject pluginInfoJson;
    private JSONObject latestPlugins;
    private boolean verbose;
    private boolean useLatestSpecified;
    private boolean useLatestAll;
    public static final String SEPARATOR = File.separator;

    public PluginManager(Config cfg) {
        this.cfg = cfg;
        this.refDir = cfg.getPluginDir();
        this.jenkinsWarFile = new File(cfg.getJenkinsWar());
        this.failedPlugins = new ArrayList<Plugin>();
        this.installedPluginVersions = new HashMap<String, Plugin>();
        this.bundledPluginVersions = new HashMap<String, Plugin>();
        this.allSecurityWarnings = new HashMap<String, List<SecurityWarning>>();
        this.allPluginsAndDependencies = new HashMap<String, Plugin>();
        this.verbose = cfg.isVerbose();
        this.jenkinsUcLatest = cfg.getJenkinsUc().toString();
        this.useLatestSpecified = cfg.isUseLatestSpecified();
        this.useLatestAll = cfg.isUseLatestAll();
    }

    public void start() {
        if (!this.refDir.exists()) {
            try {
                Files.createDirectories(this.refDir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new DirectoryCreationException("Unable to create plugin directory", e);
            }
        }
        if (this.useLatestSpecified && this.useLatestAll) {
            throw new PluginDependencyStrategyException("Only one plugin dependency version strategy can be selected at a time");
        }
        this.jenkinsVersion = this.getJenkinsVersionFromWar();
        this.checkAndSetLatestUpdateCenter();
        this.getUCJson();
        this.getSecurityWarnings();
        this.showAllSecurityWarnings();
        this.bundledPluginVersions = this.bundledPlugins();
        this.installedPluginVersions = this.installedPlugins();
        this.allPluginsAndDependencies = this.findPluginsAndDependencies(this.cfg.getPlugins());
        this.pluginsToBeDownloaded = this.findPluginsToDownload(this.allPluginsAndDependencies);
        this.effectivePlugins = this.findEffectivePlugins(this.pluginsToBeDownloaded);
        this.listPlugins();
        this.showSpecificSecurityWarnings(this.pluginsToBeDownloaded);
        this.showAvailableUpdates(this.pluginsToBeDownloaded);
        this.checkVersionCompatibility(this.pluginsToBeDownloaded);
        if (this.cfg.doDownload()) {
            this.downloadPlugins(this.pluginsToBeDownloaded);
        }
        System.out.println("Done");
    }

    public List<Plugin> findPluginsToDownload(Map<String, Plugin> requestedPlugins) {
        ArrayList<Plugin> pluginsToDownload = new ArrayList<Plugin>();
        for (Map.Entry<String, Plugin> requestedPlugin : requestedPlugins.entrySet()) {
            String pluginName = requestedPlugin.getKey();
            Plugin plugin = requestedPlugin.getValue();
            VersionNumber installedVersion = null;
            if (this.installedPluginVersions.containsKey(pluginName)) {
                installedVersion = this.installedPluginVersions.get(pluginName).getVersion();
            } else if (this.bundledPluginVersions.containsKey(pluginName)) {
                installedVersion = this.bundledPluginVersions.get(pluginName).getVersion();
            } else if (this.bundledPluginVersions.containsKey(pluginName) && this.installedPluginVersions.containsKey(pluginName)) {
                VersionNumber versionNumber = installedVersion = this.bundledPluginVersions.get(pluginName).getVersion().isNewerThan(this.installedPluginVersions.get(pluginName).getVersion()) ? this.bundledPluginVersions.get(pluginName).getVersion() : this.installedPluginVersions.get(pluginName).getVersion();
            }
            if (installedVersion == null) {
                pluginsToDownload.add(plugin);
                continue;
            }
            if (!installedVersion.isOlderThan(plugin.getVersion())) continue;
            this.logVerbose(String.format("Installed version (%s) of %s is less than minimum required version of %s, bundled plugin will be upgraded", installedVersion, pluginName, plugin.getVersion()));
            pluginsToDownload.add(plugin);
        }
        return pluginsToDownload;
    }

    public Map<String, Plugin> findEffectivePlugins(List<Plugin> pluginsToBeDownloaded) {
        HashMap<String, Plugin> effectivePlugins = new HashMap<String, Plugin>();
        for (Plugin plugin : pluginsToBeDownloaded) {
            effectivePlugins.put(plugin.getName(), plugin);
        }
        this.sortEffectivePlugins(effectivePlugins, this.installedPluginVersions);
        this.sortEffectivePlugins(effectivePlugins, this.bundledPluginVersions);
        return effectivePlugins;
    }

    private void sortEffectivePlugins(Map<String, Plugin> effectivePlugins, Map<String, Plugin> installedPluginVersions) {
        for (Map.Entry<String, Plugin> installedEntry : installedPluginVersions.entrySet()) {
            if (!effectivePlugins.containsKey(installedEntry.getKey())) {
                effectivePlugins.put(installedEntry.getKey(), installedEntry.getValue());
                continue;
            }
            if (!effectivePlugins.get(installedEntry.getKey()).getVersion().isOlderThan(installedEntry.getValue().getVersion())) continue;
            effectivePlugins.replace(installedEntry.getKey(), installedEntry.getValue());
        }
    }

    public void listPlugins() {
        if (this.cfg.isShowPluginsToBeDownloaded()) {
            this.logPlugins("Installed plugins:", new ArrayList<Plugin>(this.installedPluginVersions.values()));
            this.logPlugins("Bundled plugins:", new ArrayList<Plugin>(this.bundledPluginVersions.values()));
            this.logPlugins("Set of all requested plugins:", new ArrayList<Plugin>(this.allPluginsAndDependencies.values()));
            this.logPlugins("Set of all requested plugins that will be downloaded:", this.pluginsToBeDownloaded);
            this.logPlugins("Set of all existing plugins and plugins that will be downloaded:", new ArrayList<Plugin>(this.effectivePlugins.values()));
        }
    }

    public void logPlugins(String description, List<Plugin> plugins) {
        System.out.println("\n" + description);
        plugins.stream().sorted().forEach(System.out::println);
    }

    public Map<String, List<SecurityWarning>> getSecurityWarnings() {
        if (this.latestUcJson == null) {
            System.out.println("Unable to get update center json");
            return this.allSecurityWarnings;
        }
        JSONArray warnings = this.latestUcJson.getJSONArray("warnings");
        for (int i = 0; i < warnings.length(); ++i) {
            JSONObject warning = warnings.getJSONObject(i);
            String warningType = warning.getString("type");
            if (!warningType.equals("plugin")) continue;
            String warningId = warning.getString("id");
            String warningMessage = warning.getString("message");
            String warningName = warning.getString("name");
            String warningUrl = warning.getString("url");
            SecurityWarning securityWarning = new SecurityWarning(warningId, warningMessage, warningName, warningUrl);
            JSONArray warningVersions = warning.getJSONArray("versions");
            for (int j = 0; j < warningVersions.length(); ++j) {
                JSONObject warningVersion = warningVersions.getJSONObject(j);
                String firstVersion = "";
                if (warningVersion.has("firstVersion")) {
                    firstVersion = warningVersion.getString("firstVersion");
                }
                String lastVersion = "";
                if (warningVersion.has("lastVersion")) {
                    lastVersion = warningVersion.getString("lastVersion");
                }
                String pattern = warningVersion.getString("pattern");
                securityWarning.addSecurityVersion(firstVersion, lastVersion, pattern);
            }
            this.allSecurityWarnings.computeIfAbsent(warningName, k -> new ArrayList()).add(securityWarning);
        }
        return this.allSecurityWarnings;
    }

    public void showAllSecurityWarnings() {
        if (this.cfg.isShowAllWarnings()) {
            this.allSecurityWarnings.values().stream().sorted().forEach(p -> p.stream().sorted().map(w -> w.getName() + " - " + w.getMessage()).forEach(System.out::println));
        }
    }

    public void showSpecificSecurityWarnings(List<Plugin> plugins) {
        if (this.cfg.isShowWarnings()) {
            System.out.println("\nSecurity warnings:");
            for (Plugin plugin : plugins) {
                if (!this.warningExists(plugin)) continue;
                String pluginName = plugin.getName();
                System.out.println(plugin.getSecurityWarnings().stream().map(warning -> String.format("%s (%s): %s %s %s", pluginName, plugin.getVersion(), warning.getId(), warning.getMessage(), warning.getUrl())).collect(Collectors.joining("\n")));
            }
        }
    }

    public void showAvailableUpdates(List<Plugin> plugins) {
        if (this.cfg.isShowAvailableUpdates()) {
            System.out.println("\nAvailable updates:");
            for (Plugin plugin : plugins) {
                VersionNumber latestVersion = this.getLatestPluginVersion(plugin.getName());
                if (!plugin.getVersion().isOlderThan(latestVersion)) continue;
                System.out.println(String.format("%s (%s) has an available update: %s", plugin.getName(), plugin.getVersion(), latestVersion));
            }
        }
    }

    public boolean warningExists(Plugin plugin) {
        String pluginName = plugin.getName();
        ArrayList<SecurityWarning> securityWarnings = new ArrayList<SecurityWarning>();
        if (this.allSecurityWarnings.containsKey(pluginName)) {
            for (SecurityWarning securityWarning : this.allSecurityWarnings.get(pluginName)) {
                for (SecurityWarning.SecurityVersion effectedVersion : securityWarning.getSecurityVersions()) {
                    Matcher m = effectedVersion.getPattern().matcher(plugin.getVersion().toString());
                    if (!m.matches()) continue;
                    securityWarnings.add(securityWarning);
                }
            }
        }
        plugin.setSecurityWarnings(securityWarnings);
        return !securityWarnings.isEmpty();
    }

    public void checkVersionCompatibility(List<Plugin> pluginsToBeDownloaded) {
        if (this.jenkinsVersion != null && !StringUtils.isEmpty((CharSequence)this.jenkinsVersion.toString())) {
            for (Plugin p : pluginsToBeDownloaded) {
                if (p.getJenkinsVersion() == null || !p.getJenkinsVersion().isNewerThan(this.jenkinsVersion)) continue;
                throw new VersionCompatibilityException(String.format("%n%s (%s) requires a greater version of Jenkins (%s) than %s in %s", p.getName(), p.getVersion().toString(), p.getJenkinsVersion().toString(), this.jenkinsVersion.toString(), this.jenkinsWarFile.toString()));
            }
        }
    }

    public void checkAndSetLatestUpdateCenter() {
        if (this.jenkinsVersion != null && !StringUtils.isEmpty((CharSequence)this.jenkinsVersion.toString())) {
            String jenkinsVersionUcLatest = this.cfg.getJenkinsUc() + "/" + this.jenkinsVersion;
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpHead httphead = new HttpHead(jenkinsVersionUcLatest);
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httphead);){
                    if (response.getStatusLine().getStatusCode() == 200) {
                        System.out.println("Using version specific update center for latest plugins: " + jenkinsVersionUcLatest);
                        this.jenkinsUcLatest = jenkinsVersionUcLatest;
                    }
                }
                catch (IOException e) {
                    System.out.println("No version specific update center for Jenkins version " + this.jenkinsVersion);
                }
            }
            catch (IOException e) {
                System.out.println("Unable to check if version specific update center for Jenkins version " + this.jenkinsVersion);
            }
        }
    }

    public void downloadPlugins(List<Plugin> plugins) {
        ForkJoinPool ioThreadPool = new ForkJoinPool(64);
        try {
            ((ForkJoinTask)ioThreadPool.submit(() -> plugins.parallelStream().forEach(plugin -> {
                boolean successfulDownload = this.downloadPlugin((Plugin)plugin, null);
                if (!successfulDownload) {
                    throw new DownloadPluginException("Unable to download " + plugin.getName());
                }
            }))).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof DownloadPluginException) {
                throw (DownloadPluginException)e.getCause();
            }
            e.printStackTrace();
        }
    }

    public Map<String, Plugin> findPluginsAndDependencies(List<Plugin> requestedPlugins) {
        HashMap<String, Plugin> allPluginDependencies = new HashMap<String, Plugin>();
        for (Plugin requestedPlugin : requestedPlugins) {
            Map<String, Plugin> dependencies = this.resolveRecursiveDependencies(requestedPlugin);
            for (Plugin dependentPlugin : dependencies.values()) {
                String dependencyName = dependentPlugin.getName();
                VersionNumber dependencyVersion = dependentPlugin.getVersion();
                if (!allPluginDependencies.containsKey(dependencyName)) {
                    allPluginDependencies.put(dependencyName, dependentPlugin);
                    continue;
                }
                Plugin existingDependency = (Plugin)allPluginDependencies.get(dependencyName);
                if (!existingDependency.getVersion().isOlderThan(dependencyVersion)) continue;
                this.outputPluginReplacementInfo(existingDependency, dependentPlugin);
                allPluginDependencies.replace(existingDependency.getName(), dependentPlugin);
            }
        }
        return allPluginDependencies;
    }

    public void outputPluginReplacementInfo(Plugin lowerVersion, Plugin higherVersion) {
        this.logVerbose(String.format("Version of %s (%s) required by %s (%s) is lower than the version required (%s) by %s (%s), upgrading required plugin version", lowerVersion.getName(), lowerVersion.getVersion().toString(), lowerVersion.getParent().getName(), lowerVersion.getParent().getVersion().toString(), higherVersion.getVersion().toString(), higherVersion.getParent().getName(), higherVersion.getParent().getVersion().toString()));
    }

    public JSONObject getJson(String urlString) {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new UpdateCenterInfoRetrievalException("Malformed url for update center", e);
        }
        try {
            String urlText = IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            return new JSONObject(urlText);
        }
        catch (IOException e) {
            throw new UpdateCenterInfoRetrievalException("Error getting update center json", e);
        }
    }

    public void getUCJson() {
        this.logVerbose("\nRetrieving update center information");
        this.latestUcJson = this.getJson(this.jenkinsUcLatest + "/update-center.actual.json");
        this.latestPlugins = this.latestUcJson.getJSONObject("plugins");
        this.experimentalUcJson = this.getJson(this.cfg.getJenkinsUcExperimental() + "/update-center.actual.json");
        this.pluginInfoJson = this.getJson("https://updates.jenkins.io/current/plugin-versions.json");
    }

    public JSONArray getPluginDependencyJsonArray(Plugin plugin, JSONObject ucJson) {
        JSONObject plugins = ucJson.getJSONObject("plugins");
        if (!plugins.has(plugin.getName())) {
            return null;
        }
        JSONObject pluginInfo = (JSONObject)plugins.get(plugin.getName());
        if (ucJson.equals(this.pluginInfoJson)) {
            if (pluginInfo.has(plugin.getVersion().toString())) {
                JSONObject specificVersionInfo = pluginInfo.getJSONObject(plugin.getVersion().toString());
                plugin.setJenkinsVersion(specificVersionInfo.getString("requiredCore"));
                return (JSONArray)specificVersionInfo.get("dependencies");
            }
        } else {
            plugin.setJenkinsVersion(pluginInfo.getString("requiredCore"));
            String version = pluginInfo.getString("version");
            plugin.setVersion(new VersionNumber(version));
            return (JSONArray)pluginInfo.get("dependencies");
        }
        return null;
    }

    public VersionNumber getLatestPluginVersion(String pluginName) {
        if (!this.latestPlugins.has(pluginName)) {
            throw new PluginNotFoundException(String.format("Unable to find plugin %s in update center %s", pluginName, this.jenkinsUcLatest));
        }
        JSONObject pluginInfo = (JSONObject)this.latestPlugins.get(pluginName);
        String latestPluginVersion = pluginInfo.getString("version");
        return new VersionNumber(latestPluginVersion);
    }

    public List<Plugin> resolveDependenciesFromManifest(Plugin plugin) {
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        try {
            String[] dependencies;
            String dependencyString;
            String version;
            File tempFile = Files.createTempFile(plugin.getName(), ".jpi", new FileAttribute[0]).toFile();
            this.logVerbose(String.format("%nResolving dependencies of %s by downloading plugin to temp file %s and parsing MANIFEST.MF", plugin.getName(), tempFile.toString()));
            if (!this.downloadPlugin(plugin, tempFile)) {
                Files.delete(tempFile.toPath());
                throw new DownloadPluginException("Unable to resolve dependencies for " + plugin.getName());
            }
            if ((plugin.getVersion().toString().equals("latest") || plugin.getVersion().toString().equals("experimental")) && !StringUtils.isEmpty((CharSequence)(version = this.getAttributeFromManifest(tempFile, "Plugin-Version")))) {
                plugin.setVersion(new VersionNumber(version));
            }
            if (StringUtils.isEmpty((CharSequence)(dependencyString = this.getAttributeFromManifest(tempFile, "Plugin-Dependencies")))) {
                this.logVerbose("\n" + plugin.getName() + " has no dependencies");
                return dependentPlugins;
            }
            for (String dependency : dependencies = dependencyString.split(",")) {
                if (dependency.contains("resolution:=optional")) continue;
                String[] pluginInfo = dependency.split(":");
                String pluginName = pluginInfo[0];
                String pluginVersion = pluginInfo[1];
                Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, null, null);
                if (this.useLatestSpecified && plugin.isLatest() || this.useLatestAll) {
                    VersionNumber latestPluginVersion = this.getLatestPluginVersion(pluginName);
                    dependentPlugin.setVersion(latestPluginVersion);
                    dependentPlugin.setLatest(true);
                }
                dependentPlugins.add(dependentPlugin);
                dependentPlugin.setParent(plugin);
            }
            this.logVerbose(dependentPlugins.isEmpty() ? String.format("%n%s has no dependencies", plugin.getName()) : String.format("%n%s depends on: %n", plugin.getName()) + dependentPlugins.stream().map(p -> p.getName() + " " + p.getVersion()).collect(Collectors.joining("\n")));
            plugin.setJenkinsVersion(this.getAttributeFromManifest(tempFile, "Jenkins-Version"));
            Files.delete(tempFile.toPath());
            return dependentPlugins;
        }
        catch (IOException e) {
            System.out.println(String.format("Unable to resolve dependencies for %s", plugin.getName()));
            return dependentPlugins;
        }
    }

    public List<Plugin> resolveDependenciesFromJson(Plugin plugin, JSONObject pluginJson) {
        JSONArray dependencies = this.getPluginDependencyJsonArray(plugin, pluginJson);
        ArrayList<Plugin> dependentPlugins = new ArrayList<Plugin>();
        if (dependencies == null) {
            return null;
        }
        for (int i = 0; i < dependencies.length(); ++i) {
            JSONObject dependency = dependencies.getJSONObject(i);
            boolean isPluginOptional = dependency.getBoolean("optional");
            if (isPluginOptional) continue;
            String pluginName = dependency.getString("name");
            String pluginVersion = dependency.getString("version");
            Plugin dependentPlugin = new Plugin(pluginName, pluginVersion, null, null);
            if (this.useLatestSpecified && plugin.isLatest() || this.useLatestAll) {
                VersionNumber latestPluginVersion = this.getLatestPluginVersion(pluginName);
                dependentPlugin.setVersion(latestPluginVersion);
                dependentPlugin.setLatest(true);
            }
            dependentPlugins.add(dependentPlugin);
            dependentPlugin.setParent(plugin);
        }
        this.logVerbose(dependentPlugins.isEmpty() ? String.format("%n%s has no dependencies", plugin.getName()) : String.format("%n%s depends on: %n", plugin.getName()) + dependentPlugins.stream().map(p -> p.getName() + " " + p.getVersion()).collect(Collectors.joining("\n")));
        return dependentPlugins;
    }

    public List<Plugin> resolveDirectDependencies(Plugin plugin) {
        String version = plugin.getVersion().toString();
        if (!StringUtils.isEmpty((CharSequence)plugin.getUrl()) || !StringUtils.isEmpty((CharSequence)plugin.getGroupId())) {
            List<Plugin> dependentPlugins = this.resolveDependenciesFromManifest(plugin);
            return dependentPlugins;
        }
        List<Plugin> dependentPlugins = version.equals("latest") ? this.resolveDependenciesFromJson(plugin, this.latestUcJson) : (version.equals("experimental") ? this.resolveDependenciesFromJson(plugin, this.experimentalUcJson) : this.resolveDependenciesFromJson(plugin, this.pluginInfoJson));
        if (dependentPlugins == null) {
            return this.resolveDependenciesFromManifest(plugin);
        }
        return dependentPlugins;
    }

    public Map<String, Plugin> resolveRecursiveDependencies(Plugin plugin) {
        LinkedList<Plugin> queue = new LinkedList<Plugin>();
        HashMap<String, Plugin> recursiveDependencies = new HashMap<String, Plugin>();
        queue.add(plugin);
        recursiveDependencies.put(plugin.getName(), plugin);
        while (queue.size() != 0) {
            Plugin dependency = (Plugin)queue.poll();
            if (dependency.getDependencies().isEmpty()) {
                dependency.setDependencies(this.resolveDirectDependencies(dependency));
            }
            for (Plugin p : dependency.getDependencies()) {
                String dependencyName = p.getName();
                if (!recursiveDependencies.containsKey(dependencyName)) {
                    recursiveDependencies.put(dependencyName, p);
                    queue.add(p);
                    continue;
                }
                Plugin existingDependency = (Plugin)recursiveDependencies.get(dependencyName);
                if (!existingDependency.getVersion().isOlderThan(p.getVersion())) continue;
                this.outputPluginReplacementInfo(existingDependency, p);
                queue.add(p);
                recursiveDependencies.replace(dependencyName, existingDependency, p);
            }
        }
        return recursiveDependencies;
    }

    public boolean downloadPlugin(Plugin plugin, File location) {
        String pluginName = plugin.getName();
        VersionNumber pluginVersion = plugin.getVersion();
        if (location == null && this.installedPluginVersions.containsKey(pluginName) && this.installedPluginVersions.get(pluginName).getVersion().isNewerThanOrEqualTo(pluginVersion)) {
            this.logVerbose(pluginName + " already installed, skipping");
            return true;
        }
        String pluginDownloadUrl = this.getPluginDownloadUrl(plugin);
        boolean successfulDownload = this.downloadToFile(pluginDownloadUrl, plugin, location);
        if (!successfulDownload) {
            this.logVerbose(String.format("First download attempt of %s unsuccessful, reattempting", plugin.getName()));
            String newPluginName = plugin.getName() + "-plugin";
            plugin.setName(newPluginName);
            pluginDownloadUrl = this.getPluginDownloadUrl(plugin);
            successfulDownload = this.downloadToFile(pluginDownloadUrl, plugin, location);
        }
        if (successfulDownload && location == null) {
            System.out.println(String.format("%s downloaded successfully", plugin.getName()));
            this.installedPluginVersions.put(plugin.getName(), plugin);
        }
        return successfulDownload;
    }

    public String getPluginDownloadUrl(Plugin plugin) {
        String pluginName = plugin.getName();
        String pluginVersion = plugin.getVersion().toString();
        String pluginUrl = plugin.getUrl();
        String urlString = "";
        if (StringUtils.isEmpty((CharSequence)pluginVersion)) {
            pluginVersion = "latest";
        }
        if (!StringUtils.isEmpty((CharSequence)pluginUrl)) {
            this.logVerbose(String.format("Will use url: %s to download %s plugin", pluginUrl, plugin.getName()));
            urlString = pluginUrl;
        } else if ((pluginVersion.equals("latest") || plugin.isLatest()) && !StringUtils.isEmpty((CharSequence)this.jenkinsUcLatest)) {
            urlString = String.format("%s/latest/%s.hpi", this.jenkinsUcLatest, pluginName);
        } else if (pluginVersion.equals("experimental") || plugin.isExperimental()) {
            urlString = String.format("%s/latest/%s.hpi", this.cfg.getJenkinsUcExperimental(), pluginName);
        } else if (!StringUtils.isEmpty((CharSequence)plugin.getGroupId())) {
            String groupId = plugin.getGroupId();
            groupId = groupId.replace(".", "/");
            String incrementalsVersionPath = String.format("%s/%s/%s-%s.hpi", pluginName, pluginVersion, pluginName, pluginVersion);
            urlString = String.format("%s/%s/%s", this.cfg.getJenkinsIncrementalsRepoMirror(), groupId, incrementalsVersionPath);
        } else {
            urlString = String.format("%s/download/plugins/%s/%s/%s.hpi", this.cfg.getJenkinsUc(), pluginName, pluginVersion, pluginName);
        }
        return urlString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadToFile(String urlString, Plugin plugin, File fileLocation) {
        Throwable throwable;
        File pluginFile;
        if (fileLocation == null) {
            pluginFile = new File(this.refDir + SEPARATOR + plugin.getArchiveFileName());
            System.out.println("\nDownloading plugin " + plugin.getName() + " from url: " + urlString);
        } else {
            pluginFile = fileLocation;
        }
        try {
            throwable = null;
            try (CloseableHttpClient httpclient = HttpClients.createDefault();){
                HttpClientContext context = HttpClientContext.create();
                HttpHead httphead = new HttpHead(urlString);
                try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httphead, (HttpContext)context);){
                    HttpHost target = context.getTargetHost();
                    List redirectLocations = context.getRedirectLocations();
                    URI location = URIUtils.resolve((URI)httphead.getURI(), (HttpHost)target, (List)redirectLocations);
                    FileUtils.copyURLToFile((URL)location.toURL(), (File)pluginFile);
                }
                catch (IOException | URISyntaxException e) {
                    this.logVerbose(String.format("Unable to resolve plugin URL %s, or download plugin %s to file", urlString, plugin.getName()));
                    boolean bl = false;
                    if (httpclient == null) return bl;
                    if (throwable == null) {
                        httpclient.close();
                        return bl;
                    }
                    try {
                        httpclient.close();
                        return bl;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return bl;
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (IOException e) {
            System.out.println("Unable to create HTTP connection to download plugin");
            return false;
        }
        try {
            throwable = null;
            try (JarFile pluginJpi = new JarFile(pluginFile);){
                plugin.setFile(pluginFile);
                return true;
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
        }
        catch (IOException e) {
            this.failedPlugins.add(plugin);
            System.out.println("Downloaded file is not a valid ZIP");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAttributeFromManifest(File file, String key) {
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String string = attributes.getValue(key);
            return string;
        }
        catch (IOException e) {
            System.out.println("Unable to open " + file);
            if (!key.equals("Plugin-Dependencies")) return null;
            throw new DownloadPluginException("Unable to determine plugin dependencies", e);
        }
    }

    public VersionNumber getJenkinsVersionFromWar() {
        String version = this.getAttributeFromManifest(this.jenkinsWarFile, "Jenkins-Version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            System.out.println("Unable to get version from war file");
            return null;
        }
        this.logVerbose("Jenkins version: " + version);
        return new VersionNumber(version);
    }

    public String getPluginVersion(File file) {
        String version = this.getAttributeFromManifest(file, "Plugin-Version");
        if (StringUtils.isEmpty((CharSequence)version)) {
            System.out.println("Unable to get plugin version from " + file);
            return "";
        }
        return version;
    }

    public Map<String, Plugin> installedPlugins() {
        HashMap<String, Plugin> installedPlugins = new HashMap<String, Plugin>();
        WildcardFileFilter fileFilter = new WildcardFileFilter("*.jpi");
        File[] files = this.refDir.listFiles((FileFilter)fileFilter);
        if (files != null) {
            for (File file : files) {
                String pluginName = FilenameUtils.getBaseName((String)file.getName());
                installedPlugins.put(pluginName, new Plugin(pluginName, this.getPluginVersion(file), null, null));
            }
        }
        return installedPlugins;
    }

    public Map<String, Plugin> bundledPlugins() {
        HashMap<String, Plugin> bundledPlugins;
        block31: {
            bundledPlugins = new HashMap<String, Plugin>();
            if (this.jenkinsWarFile.exists()) {
                URI jenkinsWarUri;
                Path path = Paths.get(this.jenkinsWarFile.toString(), new String[0]);
                try {
                    jenkinsWarUri = new URI("jar:" + path.toUri());
                }
                catch (URISyntaxException e) {
                    throw new WarBundledPluginException("Unable to open war file to extract bundled plugin information", e);
                }
                try (FileSystem warFS = FileSystems.newFileSystem(jenkinsWarUri, Collections.emptyMap());){
                    Path warPath = warFS.getPath("/", new String[0]).getRoot();
                    PathMatcher matcher = warFS.getPathMatcher("regex:.*[^detached-]plugins.*\\.\\w+pi");
                    Stream<Path> walk = Files.walk(warPath, new FileVisitOption[0]);
                    Iterator it = walk.iterator();
                    while (it.hasNext()) {
                        Path fileName;
                        Path file = (Path)it.next();
                        if (!matcher.matches(file) || (fileName = file.getFileName()) == null) continue;
                        InputStream in = Files.newInputStream(file, new OpenOption[0]);
                        Path tempFile = Files.createTempFile("PREFIX", "SUFFIX", new FileAttribute[0]);
                        try (FileOutputStream out = new FileOutputStream(tempFile.toFile());){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        String pluginVersion = this.getPluginVersion(tempFile.toFile());
                        Files.delete(tempFile);
                        String pluginName = FilenameUtils.getBaseName((String)fileName.toString());
                        bundledPlugins.put(pluginName, new Plugin(pluginName, pluginVersion, null, null));
                    }
                    break block31;
                }
                catch (IOException e) {
                    throw new WarBundledPluginException("Unable to open war file to extract bundled plugin information", e);
                }
            }
            System.out.println("War not found, installing all plugins: " + this.jenkinsWarFile.toString());
        }
        return bundledPlugins;
    }

    public void setJenkinsVersion(VersionNumber jenkinsVersion) {
        this.jenkinsVersion = jenkinsVersion;
    }

    public VersionNumber getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    public String getJenkinsUCLatest() {
        return this.jenkinsUcLatest;
    }

    public void setJenkinsUCLatest(String updateCenterLatest) {
        this.jenkinsUcLatest = updateCenterLatest;
    }

    public void setInstalledPluginVersions(Map<String, Plugin> installedPlugins) {
        this.installedPluginVersions = installedPlugins;
    }

    public void setBundledPluginVersions(Map<String, Plugin> bundledPlugins) {
        this.bundledPluginVersions = bundledPlugins;
    }

    public void setAllPluginsAndDependencies(Map<String, Plugin> allPluginsAndDependencies) {
        this.allPluginsAndDependencies = allPluginsAndDependencies;
    }

    public void setEffectivePlugins(Map<String, Plugin> effectivePlugins) {
        this.effectivePlugins = effectivePlugins;
    }

    public void setPluginsToBeDownloaded(List<Plugin> pluginsToBeDownloaded) {
        this.pluginsToBeDownloaded = pluginsToBeDownloaded;
    }

    public void logVerbose(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }

    public void setLatestUcJson(JSONObject latestUcJson) {
        this.latestUcJson = latestUcJson;
    }

    public void setLatestUcPlugins(JSONObject latestPlugins) {
        this.latestPlugins = latestPlugins;
    }

    public void setAllSecurityWarnings(Map<String, List<SecurityWarning>> securityWarnings) {
        this.allSecurityWarnings = securityWarnings;
    }

    public void setPluginInfoJson(JSONObject pluginInfoJson) {
        this.pluginInfoJson = pluginInfoJson;
    }

    public List<Plugin> getFailedPlugins() {
        return this.failedPlugins;
    }
}

