/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.impl;

import hudson.util.VersionNumber;
import io.jenkins.tools.pluginmanager.impl.SecurityWarning;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Plugin
implements Comparable<Plugin> {
    private String name;
    private String originalName;
    private VersionNumber version;
    private String groupId;
    private String url;
    private File file;
    private List<Plugin> dependencies;
    private Plugin parent;
    private List<SecurityWarning> securityWarnings;
    private boolean latest;
    private boolean experimental;
    private VersionNumber jenkinsVersion;

    public Plugin(String name, String version, String url, String groupId) {
        this.originalName = name;
        this.name = name;
        if (StringUtils.isEmpty((CharSequence)version)) {
            version = "latest";
        }
        this.version = new VersionNumber(version);
        this.url = url;
        this.dependencies = new ArrayList<Plugin>();
        this.parent = this;
        this.groupId = groupId;
        this.securityWarnings = new ArrayList<SecurityWarning>();
        if (version.equals("latest")) {
            this.latest = true;
        }
        if (version.equals("experimental")) {
            this.experimental = true;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(VersionNumber version) {
        this.version = version;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setJenkinsVersion(String jenkinsVersion) {
        this.jenkinsVersion = new VersionNumber(jenkinsVersion);
    }

    public void setLatest(boolean latest) {
        this.latest = latest;
    }

    public String getName() {
        return this.name;
    }

    public VersionNumber getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String getArchiveFileName() {
        return this.name + ".jpi";
    }

    public File getFile() {
        return this.file;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setDependencies(List<Plugin> dependencies) {
        this.dependencies = dependencies;
    }

    public List<Plugin> getDependencies() {
        return this.dependencies;
    }

    public void setParent(Plugin parent) {
        this.parent = parent;
    }

    public Plugin getParent() {
        return this.parent;
    }

    public VersionNumber getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    public void setSecurityWarnings(List<SecurityWarning> securityWarnings) {
        this.securityWarnings = securityWarnings;
    }

    public List<SecurityWarning> getSecurityWarnings() {
        return this.securityWarnings;
    }

    public boolean isLatest() {
        return this.latest;
    }

    public boolean isExperimental() {
        return this.experimental;
    }

    public String toString() {
        if (this.url == null) {
            return this.name + " " + this.version;
        }
        return this.name + " " + this.version + " " + this.url;
    }

    @Override
    public int compareTo(Plugin p) {
        if (this.equals(p)) {
            return 0;
        }
        if (this.getName().equals(p.getName())) {
            return this.getVersion().compareTo(p.getVersion());
        }
        return this.getName().compareTo(p.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Plugin plugin = (Plugin)o;
        return Objects.equals(this.name, plugin.name) && Objects.equals(this.version, plugin.version) && Objects.equals(this.groupId, plugin.groupId) && Objects.equals(this.url, plugin.url);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.groupId, this.url);
    }
}

