/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.cli;

import io.jenkins.tools.pluginmanager.config.Config;
import io.jenkins.tools.pluginmanager.config.Settings;
import io.jenkins.tools.pluginmanager.impl.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.kohsuke.args4j.spi.URLOptionHandler;

class CliOptions {
    @Option(name="--plugin-file", aliases={"-f"}, usage="Path to plugins.txt file", handler=FileOptionHandler.class)
    private File pluginTxt;
    @Option(name="--plugin-download-directory", aliases={"-d"}, usage="Path to directory in which to install plugins", handler=FileOptionHandler.class)
    private File pluginDir;
    @Option(name="--plugins", aliases={"-p"}, usage="List of plugins to install, separated by a space", handler=StringArrayOptionHandler.class)
    private String[] plugins = new String[0];
    @Option(name="--war", aliases={"-w"}, usage="Path to Jenkins war file")
    private String jenkinsWarFile;
    @Option(name="--view-security-warnings", usage="Set to true to show specified plugins that have security warnings", handler=BooleanOptionHandler.class)
    private boolean showWarnings;
    @Option(name="--view-all-security-warnings", usage="Set to true to show all plugins that have security warnings", handler=BooleanOptionHandler.class)
    private boolean showAllWarnings;
    @Option(name="--jenkins-update-center", usage="Sets main update center; will override JENKINS_UC environment variable. If not set via CLI option or environment variable, will default to https://updates.jenkins.io", handler=URLOptionHandler.class)
    private URL jenkinsUc;
    @Option(name="--jenkins-experimental-update-center", usage="Sets experimental update center; will override JENKINS_UC_EXPERIMENTAL environment variable. If not set via CLI option or environment variable, will default to https://updates.jenkins.io/experimental", handler=URLOptionHandler.class)
    private URL jenkinsUcExperimental;
    @Option(name="--jenkins-incrementals-repo-mirror", usage="Set Maven mirror to be used to download plugins from the Incrementals repository, will override the JENKINS_INCREMENTALS_REPO_MIRROR environment variable. If not set via CLI option or environment variable, will default to https://repo.jenkins-ci.org/incrementals", handler=URLOptionHandler.class)
    private URL jenkinsIncrementalsRepoMirror;

    CliOptions() {
    }

    Config setup() {
        return Config.builder().withPlugins(this.getPlugins()).withPluginDir(this.getPluginDir()).withJenkinsUc(this.getUpdateCenter()).withJenkinsUcExperimental(this.getExperimentalUpdateCenter()).withJenkinsIncrementalsRepoMirror(this.getIncrementalsMirror()).withJenkinsWar(this.getJenkinsWar()).withShowWarnings(this.isShowWarnings()).withShowAllWarnings(this.isShowAllWarnings()).build();
    }

    private File getPluginTxt() {
        if (this.pluginTxt == null) {
            System.out.println("No file containing list of plugins to be downloaded entered.");
        } else {
            System.out.println("File containing list of plugins to be downloaded: " + this.pluginTxt);
        }
        return this.pluginTxt;
    }

    private File getPluginDir() {
        if (this.pluginDir != null) {
            System.out.println("Plugin download location: " + this.pluginDir);
            return this.pluginDir;
        }
        if (!StringUtils.isEmpty((CharSequence)System.getenv("PLUGIN_DIR"))) {
            System.out.println("No directory to download plugins entered. Will use location specified in PLUGIN_DIR environment variable: " + System.getenv("PLUGIN_DIR"));
            return new File(System.getenv("PLUGIN_DIR"));
        }
        System.out.println("No directory to download plugins entered. Will use default of " + Settings.DEFAULT_PLUGIN_DIR_LOCATION);
        return new File(Settings.DEFAULT_PLUGIN_DIR_LOCATION);
    }

    private String getJenkinsWar() {
        if (this.jenkinsWarFile == null) {
            System.out.println("No war entered. Will use default of " + Settings.DEFAULT_WAR);
            return Settings.DEFAULT_WAR;
        }
        System.out.println("Will use war file: " + this.jenkinsWarFile);
        return this.jenkinsWarFile;
    }

    private List<Plugin> getPlugins() {
        if (this.plugins == null) {
            return new ArrayList<Plugin>();
        }
        List<Plugin> mappedPlugins = Arrays.stream(this.plugins).map(this::parsePluginLine).collect(Collectors.toList());
        File pluginFileLocation = this.getPluginTxt();
        if (pluginFileLocation == null) {
            return mappedPlugins;
        }
        if (Files.exists(pluginFileLocation.toPath(), new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(pluginFileLocation.toPath(), StandardCharsets.UTF_8);){
                System.out.println("Reading in plugins from " + pluginFileLocation + "\n");
                List pluginsFromFile = bufferedReader.lines().map(line -> line.replaceAll("\\s", "")).filter(line -> !line.startsWith("#")).filter(line -> line.length() > 0).map(line -> this.parsePluginLine((String)line)).collect(Collectors.toList());
                mappedPlugins.addAll(pluginsFromFile);
            }
            catch (IOException e) {
                System.out.println("Unable to open " + pluginFileLocation);
            }
        } else {
            System.out.println(pluginFileLocation + " File does not exist");
        }
        return mappedPlugins;
    }

    private Plugin parsePluginLine(String pluginLine) {
        String[] pluginInfo = pluginLine.split(":", 3);
        String pluginName = pluginInfo[0];
        String pluginVersion = "latest";
        String pluginUrl = null;
        UrlValidator urlValidator = new UrlValidator();
        if (pluginInfo.length >= 2 && !StringUtils.isEmpty((CharSequence)pluginInfo[1])) {
            pluginVersion = pluginInfo[1];
        }
        if (pluginInfo.length >= 3) {
            if (urlValidator.isValid(pluginInfo[2])) {
                pluginUrl = pluginInfo[2];
            } else {
                System.out.println("Invalid URL entered, will ignore");
            }
        }
        return new Plugin(pluginName, pluginVersion, pluginUrl);
    }

    private boolean isShowWarnings() {
        return this.showWarnings;
    }

    private boolean isShowAllWarnings() {
        return this.showAllWarnings;
    }

    private URL getUpdateCenter() {
        URL jenkinsUpdateCenter;
        if (this.jenkinsUc != null) {
            jenkinsUpdateCenter = this.jenkinsUc;
            System.out.println("Using update center " + jenkinsUpdateCenter + " specified with CLI option");
        } else if (!StringUtils.isEmpty((CharSequence)System.getenv("JENKINS_UC"))) {
            try {
                jenkinsUpdateCenter = new URL(System.getenv("JENKINS_UC"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            System.out.println("Using update center " + jenkinsUpdateCenter + " from JENKINS_UC environment variable");
        } else {
            jenkinsUpdateCenter = Settings.DEFAULT_UPDATE_CENTER;
            System.out.println("No CLI option or environment variable set for update center, using default of " + jenkinsUpdateCenter);
        }
        return jenkinsUpdateCenter;
    }

    private URL getExperimentalUpdateCenter() {
        URL experimentalUpdateCenter;
        if (this.jenkinsUcExperimental != null) {
            experimentalUpdateCenter = this.jenkinsUcExperimental;
            System.out.println("Using experimental update center " + experimentalUpdateCenter + " specified with CLI option");
        } else if (!StringUtils.isEmpty((CharSequence)System.getenv("JENKINS_UC_EXPERIMENTAL"))) {
            try {
                experimentalUpdateCenter = new URL(System.getenv("JENKINS_UC_EXPERIMENTAL"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            System.out.println("Using experimental update center " + experimentalUpdateCenter + " from JENKINS_UC_EXPERIMENTAL environemnt variable");
        } else {
            experimentalUpdateCenter = Settings.DEFAULT_EXPERIMENTAL_UPDATE_CENTER;
            System.out.println("No CLI option or environment variable set for experimental update center, using default of " + experimentalUpdateCenter);
        }
        return experimentalUpdateCenter;
    }

    private URL getIncrementalsMirror() {
        URL jenkinsIncrementalsRepo;
        if (this.jenkinsIncrementalsRepoMirror != null) {
            jenkinsIncrementalsRepo = this.jenkinsIncrementalsRepoMirror;
            System.out.println("Using incrementals mirror " + jenkinsIncrementalsRepo + " specified with CLI option");
        } else if (!StringUtils.isEmpty((CharSequence)System.getenv("JENKINS_INCREMENTALS_REPO_MIRROR"))) {
            try {
                jenkinsIncrementalsRepo = new URL(System.getenv("JENKINS_INCREMENTALS_REPO_MIRROR"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            System.out.println("Using incrementals mirror " + jenkinsIncrementalsRepo + " from JENKINS_INCREMENTALS_REPO_MIRROR environment variable");
        } else {
            jenkinsIncrementalsRepo = Settings.DEFAULT_INCREMENTALS_REPO_MIRROR;
            System.out.println("No CLI option or environment variable set for incrementals mirror, using default of " + jenkinsIncrementalsRepo);
        }
        return jenkinsIncrementalsRepo;
    }
}

