/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.tools.pluginmanager.cli;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;

public class CliOptions {
    @Option(name="-pluginTxtPath", usage="Path to plugins.txt")
    public File pluginTxt;
    @Option(name="-pluginDirPath", usage="Directory in which to install plugins")
    public File pluginDir;
    @Option(name="-plugins", usage="List of plugins to install, separated by a space", handler=StringArrayOptionHandler.class)
    public String[] plugins;
    @Option(name="-war", usage="Path to Jenkins war file")
    public String jenkinsWarFile;
    @Option(name="-viewSecurityWarnings", usage="Set to true to show specified plugins that have security warnings", handler=BooleanOptionHandler.class)
    public boolean showWarnings;
    @Option(name="-viewAllSecurityWarnings", usage="Set to true to show all plugins that have security warnings", handler=BooleanOptionHandler.class)
    public boolean showAllWarnings;

    public File getPluginTxt() {
        return this.pluginTxt;
    }

    public File getPluginDir() {
        return this.pluginDir;
    }

    public String getJenkinsWar() {
        return this.jenkinsWarFile;
    }

    public List<String> getPlugins() {
        if (this.plugins != null) {
            return new ArrayList<String>(Arrays.asList(this.plugins));
        }
        return new ArrayList<String>();
    }

    public boolean isShowWarnings() {
        return this.showWarnings;
    }

    public boolean isShowAllWarnings() {
        return this.showAllWarnings;
    }
}

