/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.pipeline;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerAttachConnector;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;

class DockerNodeStepExecution
extends StepExecution {
    private final String dockerHost;
    private final String credentialsId;
    private final String image;
    private final String remoteFs;
    private final DockerComputerConnector connector;
    private volatile transient CompletableFuture<DockerTransientNode> task;
    private volatile String nodeName;

    public DockerNodeStepExecution(StepContext context, DockerComputerConnector connector, String dockerHost, String credentialsId, String image, String remoteFs) {
        super(context);
        this.connector = connector != null ? connector : new DockerComputerAttachConnector();
        this.dockerHost = dockerHost;
        this.credentialsId = credentialsId;
        this.image = image;
        this.remoteFs = remoteFs;
    }

    public boolean start() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        listener.getLogger().println("Launching new docker node based on " + this.image);
        this.task = CompletableFuture.supplyAsync(() -> this.createNode(listener));
        this.task.thenAccept(node -> this.invokeBody((DockerTransientNode)((Object)node), listener));
        return false;
    }

    public void onResume() {
        try {
            if (this.nodeName == null) {
                this.start();
            }
        }
        catch (Exception x) {
            this.getContext().onFailure((Throwable)x);
        }
    }

    private DockerTransientNode createNode(TaskListener listener) {
        DockerTransientNode node;
        String uuid = UUID.randomUUID().toString();
        DockerTemplate t = new DockerTemplate(new DockerTemplateBase(this.image), this.connector, uuid, this.remoteFs, "1");
        t.setMode(Node.Mode.EXCLUSIVE);
        DockerAPI api = this.dockerHost == null && this.credentialsId == null ? DockerNodeStepExecution.defaultApi() : new DockerAPI(new DockerServerEndpoint(this.dockerHost, this.credentialsId));
        Computer computer = null;
        try {
            node = t.provisionNode(api, listener);
            node.setAcceptingTasks(false);
            Jenkins.getInstance().addNode((Node)node);
            listener.getLogger().println("Waiting for node to be online ...");
            while ((computer = node.toComputer()) == null || computer.isOffline()) {
                Thread.sleep(1000L);
            }
            listener.getLogger().println("Node " + node.getNodeName() + " is online.");
        }
        catch (Exception e) {
            if (computer != null) {
                try {
                    listener.getLogger().write(computer.getLog().getBytes());
                }
                catch (IOException x) {
                    listener.getLogger().println("Failed to capture docker agent provisioning log " + x);
                }
            }
            this.getContext().onFailure((Throwable)e);
            return null;
        }
        return node;
    }

    private static DockerAPI defaultApi() {
        for (Cloud cloud : Jenkins.getInstance().clouds) {
            if (!(cloud instanceof DockerCloud)) continue;
            return ((DockerCloud)cloud).getDockerApi();
        }
        throw new IllegalStateException("Must either specify dockerHost/credentialsId, or define at least one Docker cloud");
    }

    private void invokeBody(DockerTransientNode node, TaskListener listener) {
        this.nodeName = node.getNodeName();
        FilePath ws = null;
        Computer computer = null;
        EnvVars env = null;
        try {
            ws = node.createPath(node.getRemoteFS() + "/workspace");
            FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
            flowNode.addAction((Action)new WorkspaceActionImpl(ws, flowNode));
            computer = node.toComputer();
            if (computer == null) {
                throw new IllegalStateException("Agent not started");
            }
            env = computer.getEnvironment();
            env.overrideExpandingAll((Map)computer.buildEnvironment(listener));
            env.put("NODE_NAME", computer.getName());
            env.put("EXECUTOR_NUMBER", "0");
            env.put("NODE_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
            env.put("WORKSPACE", ws.getRemote());
        }
        catch (IOException | InterruptedException e) {
            this.getContext().onFailure((Throwable)e);
        }
        this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback((Node)node)).withContexts(new Object[]{computer, env, ws}).start();
    }

    public void stop(@Nonnull Throwable cause) throws Exception {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private final String nodeName;

        public Callback(Node node) {
            this.nodeName = node.getNodeName();
        }

        protected void finished(StepContext context) throws Exception {
            DockerTransientNode node = (DockerTransientNode)Jenkins.getInstance().getNode(this.nodeName);
            if (node != null) {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                listener.getLogger().println("Terminating docker node ...");
                node.terminate(listener);
                Jenkins.getInstance().removeNode((Node)node);
            }
        }
    }
}

