/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.thoughtworks.xstream.InitializationException;
import hudson.model.AbstractDescribableImpl;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerDelegatingComputerLauncher;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DockerComputerConnector
extends AbstractDescribableImpl<DockerComputerConnector> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComputerConnector.class);
    protected static final File remoting;

    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
    }

    public void beforeContainerStarted(DockerAPI api, String workdir, String containerId) throws IOException, InterruptedException {
    }

    public void afterContainerStarted(DockerAPI api, String workdir, String containerId) throws IOException, InterruptedException {
    }

    protected void ensureWaiting(CreateContainerCmd cmd) {
        if (cmd.getCmd() == null || cmd.getCmd().length == 0) {
            cmd.withCmd(new String[]{"/bin/sh"}).withTty(Boolean.valueOf(true)).withAttachStdin(Boolean.valueOf(false));
        }
    }

    protected String injectRemotingJar(String containerId, String workdir, DockerClient client) throws IOException {
        client.copyArchiveToContainerCmd(containerId).withHostResource(remoting.getAbsolutePath()).withRemotePath(workdir).exec();
        return workdir + '/' + remoting.getName();
    }

    public final ComputerLauncher createLauncher(DockerAPI api, @Nonnull String containerId, String workdir, TaskListener listener) throws IOException, InterruptedException {
        InspectContainerResponse inspect;
        try (DockerClient client = api.getClient();){
            inspect = client.inspectContainerCmd(containerId).exec();
        }
        ComputerLauncher launcher = this.createLauncher(api, workdir, inspect, listener);
        Boolean running = inspect.getState().getRunning();
        if (Boolean.FALSE.equals(running)) {
            listener.error("Container {} is not running. {}", new Object[]{containerId, inspect.getState().getStatus()});
            throw new IOException("Container is not running.");
        }
        return new DockerDelegatingComputerLauncher(launcher, api, containerId);
    }

    protected abstract ComputerLauncher createLauncher(DockerAPI var1, String var2, InspectContainerResponse var3, TaskListener var4) throws IOException, InterruptedException;

    static {
        try {
            remoting = Which.jarFile(Channel.class);
        }
        catch (IOException e) {
            throw new InitializationException("Failed to resolve path to remoting.jar");
        }
    }
}

