/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.command.InspectContainerResponse;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.client.DockerMultiplexedInputStream;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.Socket;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerComputerAttachConnector
extends DockerComputerConnector
implements Serializable {
    private String user;

    @DataBoundConstructor
    public DockerComputerAttachConnector() {
    }

    public DockerComputerAttachConnector(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    @DataBoundSetter
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
        this.ensureWaiting(cmd);
    }

    @Override
    public void afterContainerStarted(DockerAPI api, String workdir, String containerId) throws IOException, InterruptedException {
        try (DockerClient client = api.getClient();){
            this.injectRemotingJar(containerId, workdir, client);
        }
    }

    @Override
    protected ComputerLauncher createLauncher(DockerAPI api, String workdir, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        return new DockerAttachLauncher(api, inspect.getId(), this.user, workdir);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComputerAttachConnector that = (DockerComputerAttachConnector)o;
        return this.user != null ? this.user.equals(that.user) : that.user == null;
    }

    private static class DockerAttachLauncher
    extends ComputerLauncher {
        private final DockerAPI api;
        private final String containerId;
        private final String user;
        private final String remoteFs;

        private DockerAttachLauncher(DockerAPI api, String containerId, String user, String remoteFs) {
            this.api = api;
            this.containerId = containerId;
            this.user = user;
            this.remoteFs = remoteFs;
        }

        public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
            String execId;
            PrintStream logger = computer.getListener().getLogger();
            logger.println("Connecting to docker container " + this.containerId);
            try (DockerClient client = this.api.getClient();){
                ExecCreateCmd cmd = client.execCreateCmd(this.containerId).withAttachStdin(Boolean.valueOf(true)).withAttachStdout(Boolean.valueOf(true)).withAttachStderr(Boolean.valueOf(true)).withTty(Boolean.valueOf(false)).withCmd(new String[]{"java", "-jar", this.remoteFs + '/' + DockerComputerConnector.remoting.getName(), "-noReconnect", "-noKeepAlive", "-slaveLog", this.remoteFs + "/agent.log"});
                if (StringUtils.isNotBlank((String)this.user)) {
                    cmd.withUser(this.user);
                }
                ExecCreateCmdResponse exec = (ExecCreateCmdResponse)cmd.exec();
                execId = exec.getId();
            }
            String js = "{ \"Detach\": false, \"Tty\": false }";
            Socket socket = this.api.getSocket();
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            PrintWriter w = new PrintWriter(out);
            w.println("POST /v1.32/exec/" + execId + "/start HTTP/1.1");
            w.println("Host: docker.sock");
            w.println("Content-Type: application/json");
            w.println("Upgrade: tcp");
            w.println("Connection: Upgrade");
            w.println("Content-Length: " + js.length());
            w.println();
            w.println(js);
            w.flush();
            String line = this.readLine(in);
            logger.println(line);
            if (!line.startsWith("HTTP/1.1 101 ")) {
                throw new IOException("Unexpected HTTP response status line " + line);
            }
            while ((line = this.readLine(in)).length() > 0 && line.length() != 0) {
                logger.println(line);
            }
            DockerMultiplexedInputStream demux = new DockerMultiplexedInputStream(in);
            computer.setChannel((InputStream)demux, out, listener, new Channel.Listener(){

                public void onClosed(Channel channel, IOException cause) {
                }
            });
        }

        private String readLine(InputStream in) throws IOException {
            int c;
            StringBuilder s = new StringBuilder();
            while ((c = in.read()) > 0 && c != 13) {
                s.append((char)c);
            }
            in.read();
            return s.toString();
        }
    }

    @Extension(ordinal=100.0)
    @Symbol(value={"attach"})
    public static class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDisplayName() {
            return "Attach Docker container";
        }
    }
}

