/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.netty.MediaType;
import com.github.dockerjava.netty.WebTarget;
import com.github.dockerjava.netty.exec.AbstrSyncDockerCmdExec;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListContainersCmdExec
extends AbstrSyncDockerCmdExec<ListContainersCmd, List<Container>>
implements ListContainersCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListContainersCmdExec.class);

    public ListContainersCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    protected List<Container> execute(ListContainersCmd command) {
        WebTarget webTarget = this.getBaseResource().path(new String[]{"/containers/json"}).queryParam("since", (Object)command.getSinceId()).queryParam("before", (Object)command.getBeforeId());
        webTarget = this.booleanQueryParam(webTarget, "all", command.hasShowAllEnabled());
        webTarget = this.booleanQueryParam(webTarget, "size", command.hasShowSizeEnabled());
        if (command.getLimit() != null && command.getLimit() >= 0) {
            webTarget = webTarget.queryParam("limit", (Object)String.valueOf(command.getLimit()));
        }
        if (command.getFilters() != null && !command.getFilters().isEmpty()) {
            String encodedFilters;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                encodedFilters = objectMapper.writeValueAsString((Object)command.getFilters());
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(ex);
            }
            webTarget = webTarget.queryParam("filters", (Object)encodedFilters);
        }
        List containers = (List)webTarget.request().accept(MediaType.APPLICATION_JSON).get((TypeReference)new TypeReference<List<Container>>(){});
        return containers;
    }
}

