/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

public class UniqueIdGenerator {
    private final int radix;
    private final int idLength;
    private long lastNanoTimeUsed;

    public UniqueIdGenerator(int radix) {
        this.radix = radix;
        this.lastNanoTimeUsed = System.nanoTime() - 1L;
        this.idLength = Long.toUnsignedString(-1L, radix).length();
    }

    public String getUniqueId() {
        long uniqueNumber = this.getNextUniqueNumber();
        String uniqueString = Long.toUnsignedString(uniqueNumber, this.radix);
        int lengthOfUniqueString = uniqueString.length();
        int paddingRequired = this.idLength - lengthOfUniqueString;
        StringBuilder paddedBuffer = new StringBuilder(this.idLength);
        paddedBuffer.setLength(this.idLength);
        for (int i = 0; i < paddingRequired; ++i) {
            paddedBuffer.setCharAt(i, '0');
        }
        paddedBuffer.replace(paddingRequired, this.idLength, uniqueString);
        return paddedBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextUniqueNumber() {
        long currentNanoTime = System.nanoTime();
        UniqueIdGenerator uniqueIdGenerator = this;
        synchronized (uniqueIdGenerator) {
            long nanosSinceLastTime = currentNanoTime - this.lastNanoTimeUsed;
            if (nanosSinceLastTime > 0L) {
                this.lastNanoTimeUsed = currentNanoTime;
                return currentNanoTime;
            }
            ++this.lastNanoTimeUsed;
            return this.lastNanoTimeUsed;
        }
    }
}

