/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.utils;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.nirima.jenkins.plugins.docker.DockerCloud;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Node;
import hudson.model.Run;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.Cloud;
import io.jenkins.docker.DockerTransientNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JenkinsUtils.class);
    private static String _id;

    public static Optional<DockerCloud> getCloudForBuild(AbstractBuild build) {
        Node node = build.getBuiltOn();
        if (node instanceof DockerTransientNode) {
            return Optional.of(((DockerTransientNode)node).getCloud());
        }
        return Optional.empty();
    }

    public static Optional<DockerCloud> getCloudForChannel(VirtualChannel channel) {
        if (channel instanceof Channel) {
            Channel c = (Channel)channel;
            Node node = Jenkins.getInstance().getNode(c.getName());
            if (node instanceof DockerTransientNode) {
                return Optional.of(((DockerTransientNode)node).getCloud());
            }
        }
        return Optional.empty();
    }

    public static Optional<DockerCloud> getCloudThatWeBuiltOn(Run<?, ?> build, Launcher launcher) {
        Optional<DockerCloud> cloud = build instanceof AbstractBuild ? JenkinsUtils.getCloudForBuild((AbstractBuild)build) : JenkinsUtils.getCloudForChannel(launcher.getChannel());
        return cloud;
    }

    public static synchronized Collection<DockerCloud> getServers() {
        Collection clouds = Collections2.filter((Collection)Jenkins.getInstance().clouds, (Predicate)new Predicate<Cloud>(){

            public boolean apply(@Nullable Cloud input) {
                return input instanceof DockerCloud;
            }
        });
        return clouds;
    }

    public static DockerCloud getServer(final String serverName) {
        return (DockerCloud)((Object)Iterables.find(JenkinsUtils.getServers(), (Predicate)new Predicate<DockerCloud>(){

            public boolean apply(@Nullable DockerCloud input) {
                return serverName.equals(input.getDisplayName());
            }
        }));
    }

    public static String getInstanceId() {
        try {
            if (_id == null) {
                _id = Util.getDigestOf((InputStream)new ByteArrayInputStream(InstanceIdentity.get().getPublic().getEncoded()));
            }
        }
        catch (IOException e) {
            LOG.error("Could not get Jenkins instance ID.");
            _id = "";
        }
        return _id;
    }

    @Restricted(value={NoExternalUse.class})
    public static void setTestInstanceId(String id) {
        _id = id;
    }

    @Restricted(value={NoExternalUse.class})
    public static String getSystemPropertyString(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Restricted(value={NoExternalUse.class})
    public static Long getSystemPropertyLong(String key, Long defaultValue) {
        String value = JenkinsUtils.getSystemPropertyString(key, null);
        if (value == null) {
            return defaultValue;
        }
        Long longValue = null;
        try {
            longValue = Long.decode(value);
        }
        catch (NumberFormatException e) {
            LOG.warn("System property {} is attempted to be read as type Long, but value '{}' cannot be parsed as a number", new Object[]{key, value, e});
            return defaultValue;
        }
        return longValue;
    }

    @Restricted(value={NoExternalUse.class})
    public static boolean getSystemPropertyBoolean(String key, boolean defaultValue) {
        String value = JenkinsUtils.getSystemPropertyString(key, null);
        if (value == null) {
            return defaultValue;
        }
        boolean booleanValue = false;
        booleanValue = Boolean.parseBoolean(value);
        return booleanValue;
    }
}

