/*
 * Decompiled with CFR 0.152.
 */
package com.nirima.jenkins.plugins.docker.strategy;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import hudson.util.FormValidation;
import io.jenkins.docker.DockerComputer;
import io.jenkins.docker.DockerTransientNode;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.durabletask.executors.ContinuableExecutable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DockerOnceRetentionStrategy
extends RetentionStrategy<DockerComputer>
implements ExecutorListener {
    private static final Logger LOGGER = Logger.getLogger(DockerOnceRetentionStrategy.class.getName());
    private static int DEFAULT_IDLEMINUTES = 10;
    private int idleMinutes = DEFAULT_IDLEMINUTES;

    @DataBoundConstructor
    public DockerOnceRetentionStrategy(int idleMinutes) {
        this.idleMinutes = idleMinutes;
    }

    public int getIdleMinutes() {
        if (this.idleMinutes < 1) {
            this.idleMinutes = DEFAULT_IDLEMINUTES;
        }
        return this.idleMinutes;
    }

    public long check(@Nonnull DockerComputer c) {
        long idleMilliseconds;
        if (c.isIdle() && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit.MINUTES.toMillis(this.getIdleMinutes())) {
            LOGGER.log(Level.FINE, "Disconnecting {0}", c.getName());
            this.done(c);
        }
        return 1L;
    }

    public void start(DockerComputer c) {
        if (c.getNode() instanceof EphemeralNode) {
            throw new IllegalStateException("May not use OnceRetentionStrategy on an EphemeralNode: " + (Object)((Object)c));
        }
        c.connect(true);
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    private void done(Executor executor) {
        DockerComputer c = (DockerComputer)executor.getOwner();
        Queue.Executable exec = executor.getCurrentExecutable();
        if (exec instanceof ContinuableExecutable && ((ContinuableExecutable)exec).willContinue()) {
            LOGGER.log(Level.FINE, "not terminating {0} because {1} says it will be continued", new Object[]{c.getName(), exec});
            return;
        }
        LOGGER.log(Level.FINE, "terminating {0} since {1} seems to be finished", new Object[]{c.getName(), exec});
        this.done(c);
    }

    private synchronized void done(DockerComputer c) {
        c.setAcceptingTasks(false);
        Computer.threadPoolForRemoting.submit(() -> Queue.withLock(() -> {
            DockerTransientNode node = c.getNode();
            if (node != null) {
                node.terminate(c.getListener());
            }
        }));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DockerOnceRetentionStrategy that = (DockerOnceRetentionStrategy)((Object)o);
        return this.idleMinutes == that.idleMinutes;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        public String getDisplayName() {
            return "Use container only once";
        }

        public FormValidation doCheckIdleMinutes(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }
    }
}

